call spQuery_Report_Lista_Precios(1, 1, NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Report_Lista_Precios;
CREATE PROCEDURE spQuery_Report_Lista_Precios (
  varEmpresa    int,
  varProveedor  int,
  varLista      text,
  varLinea      varchar(10),
  varFamilia    varchar(10),
  varSubFamilia varchar(10)
  )
BEGIN
  DROP TEMPORARY TABLE IF EXISTS _tmp_lista;
  CREATE TEMPORARY TABLE IF NOT EXISTS _tmp_lista(
    `id_lista` int(11) NOT NULL default '0',
    `nombre` varchar(60) default NULL,
    `abrev` varchar(20) default NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=latin1;
  
  if varLista is not null then
    SET @sql = CONCAT("insert into _tmp_lista ",
                      "select id_lista, nombre, substring(nombre,1,6) ",
                      "from _sv_lista ",
                      "where id_lista in ", varLista, " ", 
                      "and id_empresa = ", varEmpresa, " ",
                      "and _estado = 'A';");
    PREPARE s1 FROM @sql;
    EXECUTE s1;
  else
    insert into _tmp_lista
    select id_lista, nombre, substring(nombre,1,6)
    from _sv_lista
    where _estado = 'A' and id_empresa = varEmpresa;
  end if;
  
  call spQuery_Report_Lista_Precios_Det(varEmpresa, varProveedor, varLinea, varFamilia, varSubFamilia);
END;


DROP PROCEDURE IF EXISTS spQuery_Report_Lista_Precios_Det;
CREATE PROCEDURE spQuery_Report_Lista_Precios_Det (
  varEmpresa    int,
  varProveedor  int,
  varLinea      varchar(10),
  varFamilia    varchar(10),
  varSubFamilia varchar(10)
  )
BEGIN
  DECLARE varCod, varNom, varSQL, varCadPro, varCadLin, varCadFam, varCadSub  TEXT DEFAULT '';
  DECLARE done INT DEFAULT 0;
  DECLARE curListaP CURSOR FOR 
		      select id_lista, abrev 
          from _tmp_lista;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  OPEN curListaP;
    REPEAT
      FETCH curListaP INTO varCod, varNom;
      IF NOT done THEN
        SET varSQL = CONCAT(varSQL, ", avg(case when LP.id_lista=",varCod," then LP.precio end) as '",varNom,"' ");  
      END IF;
      UNTIL done END REPEAT;
    CLOSE curListaP;
  
  if varProveedor is not null then
    set varCadPro = CONCAT("and A.id_proveedor = ", varProveedor, " ");
  end if;
  
  if varLinea is not null and varLinea <> '' then
    set varCadLin = CONCAT("and A.id_tipo = ", varLinea, " ");
  end if;
  
  if varFamilia is not null and varFamilia <> '' then
    set varCadFam = CONCAT("and A.id_familia = ", varFamilia, " ");
  end if;
  
  if varSubFamilia is not null and varSubFamilia <> '' then
    set varCadSub = CONCAT("and A.id_sub_familia = ", varSubFamilia, " ");
  end if;
  
  SET @sql = CONCAT("select A.id_proveedor as CPRO, P.nombre as PROVEEDOR, ",
                    "A.id_tipo as CTIP, T.nombre as TIPO, ",
                    "A.id_familia as CFAM, F.nombre as FAMILIA, ",
                    "A.id_sub_familia as CSUB, S.nombre as SUB_FAMILIA, ",
                    "LP.id_producto as CART, A.descripcion as ARTICULO, ",
                    "LP.id_um as UM ",
                    varSQL,
                    "from _sv_lista_producto LP ",
                    "inner join _tmp_lista LT     ON LP.id_lista = LT.id_lista ",
                    "inner join _sv_producto A    ON LP.id_producto = A.id_producto ",
                    "inner join _sv_proveedor P   ON A.id_proveedor = P.id_proveedor ",
                    "inner join _sv_tipo T        ON A.id_tipo = T.id_tipo ",
                    "inner join _sv_familia F     ON A.id_familia = F.id_familia ",
                    "inner join _sv_sub_familia S ON A.id_sub_familia = S.id_sub_familia ",
                    "inner join _sv_kardex K      ON LP.id_producto = K.id_producto and id_almacen=1 "
                    "where A._estado = 'A' ",
                    "and P.estado = 'A' ",
                    varCadPro, varCadLin, varCadFam, varCadSub,
                    "and LP.id_empresa = ", varEmpresa, " ",
                    "group by A.id_proveedor, P.nombre, ",
                    "A.id_tipo, T.nombre, A.id_familia, F.nombre, A.id_sub_familia, S.nombre, ",
                    "LP.id_producto, A.descripcion, LP.id_um ",
                    "order by A.id_proveedor, T.nombre, F.nombre, S.nombre, A.descripcion; ");
  
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;

/*
DROP PROCEDURE IF EXISTS spQuery_Report_Lista_Precios;
CREATE PROCEDURE spQuery_Report_Lista_Precios (
  varEmpresa    int,
  varProveedor  int,
  varLinea      varchar(10),
  varFamilia    varchar(10),
  varSubFamilia varchar(10)
  )
BEGIN
  DECLARE varCod, varNom, varSQL, varCadPro, varCadLin, varCadFam, varCadSub  TEXT DEFAULT '';
  DECLARE done INT DEFAULT 0;
  DECLARE curListaP CURSOR FOR 
		      select id_lista, nombre from _sv_lista where _estado='A' and id_empresa=varEmpresa;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  OPEN curListaP;
    REPEAT
      FETCH curListaP INTO varCod, varNom;
      IF NOT done THEN
        SET varSQL = CONCAT(varSQL, ", avg(case when LP.id_lista=",varCod," then LP.precio end) as '",varNom,"' ");  
      END IF;
      UNTIL done END REPEAT;
    CLOSE curListaP;
  
  if varProveedor is not null then
    set varCadPro = CONCAT("and A.id_proveedor = ", varProveedor, " ");
  end if;
  
  if varLinea is not null and varLinea <> '' then
    set varCadLin = CONCAT("and A.id_tipo = ", varLinea, " ");
  end if;
  
  if varFamilia is not null and varFamilia <> '' then
    set varCadFam = CONCAT("and A.id_familia = ", varFamilia, " ");
  end if;
  
  if varSubFamilia is not null and varSubFamilia <> '' then
    set varCadSub = CONCAT("and A.id_sub_familia = ", varSubFamilia, " ");
  end if;
  
  SET @sql = CONCAT("select A.id_tipo as CTIP, T.nombre as TIPO, ",
                    "A.id_familia as CFAM, F.nombre as FAMILIA, ",
                    "A.id_sub_familia as CSUB, S.nombre as SUB_FAMILIA, ",
                    "LP.id_producto as CART, A.descripcion as ARTICULO, ",
                    "LP.id_um as UM ",
                    varSQL,
                    "from _sv_lista_producto LP ",
                    "inner join _sv_producto A    ON LP.id_producto = A.id_producto ",                    
                    "inner join _sv_tipo T        ON A.id_tipo = T.id_tipo ",
                    "inner join _sv_familia F     ON A.id_familia = F.id_familia ",
                    "inner join _sv_sub_familia S ON A.id_sub_familia = S.id_sub_familia ",
                    "where A._estado = 'A' ",
                    "and LP.id_empresa = ", varEmpresa, " ",
                    varCadPro, varCadLin, varCadFam, varCadSub,
                    "group by  ",
                    "A.id_tipo, T.nombre, A.id_familia, F.nombre, A.id_sub_familia, S.nombre, ",
                    "LP.id_producto, A.descripcion, LP.id_um ",
                    "order by T.nombre, F.nombre, S.nombre, A.descripcion; ");
  
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
*/