call spQuery_Report_AnalComp_Vendedor_Dia('2011','09', 'T');

DROP PROCEDURE IF EXISTS spQuery_Report_AnalComp_Vendedor_Dia;
CREATE PROCEDURE spQuery_Report_AnalComp_Vendedor_Dia(
	varAnio   varchar(4),
  varMes    varchar(4),
	varTipo   char(1)
)
BEGIN
  DECLARE varSQLTipo, varSQLCab  TEXT DEFAULT '';
  DECLARE varNumDia int;
  DECLARE varFechaIni, varFechaFin date;
  
  set varFechaIni = STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  set varFechaFin = LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'));   
  
  if varTipo = 'V' then
    set varSQLTipo = "D.subtotal";
  elseif varTipo = 'I' then
    set varSQLTipo = "D.igv";
  elseif varTipo = 'T' then
    set varSQLTipo = "D.total";
  end if;
  
  SET varNumDia = DAY(varFechaFin);
  SET @x = 1;
  REPEAT     
    SET varSQLCab = CONCAT(varSQLCab, "sum(case when day(V.fecha_emision)=", @x, "  then ", varSQLTipo, " end) as DIA_", LPAD(@x,2,'0'), ", ");
    SET @x = @x + 1; 
    UNTIL @x > varNumDia
  END REPEAT;
  
  SET @sql = CONCAT("select 'TOT' AS TOT, 'TOTALES' AS TOTALES, ",
                    "Ve.id_tipo_trabajador as CTIP, T.nombre as TIPO, ",
                    "V.id_trabajador as CVEN, Ve.nombre as VENDEDOR, ",
                    varSQLCab,
                    "sum(", varSQLTipo, ") as TOTAL " ,
                    "from _sv_venta_detalle D ",
                    "inner jo