call spQuery_Report_AnalCompDia_Proveedor(1, NULL, '2012', '09', 'V');
call spQuery_Report_AnalCompDia_Proveedor(1, NULL, '2012', '09', 'V');
DROP PROCEDURE IF EXISTS spQuery_Report_AnalCompDia_Proveedor;
CREATE PROCEDURE spQuery_Report_AnalCompDia_Proveedor(
  varEmpresa  int,
  varVendedor int,
	varAnio     varchar(4),
  varMes      varchar(2),
	varTipo     char(1)
)
BEGIN
  DECLARE varSQLTipo, varSQLCab, varCadVen  TEXT DEFAULT '';
  
  DECLARE varNumDia int;
  DECLARE varFechaIni, varFechaFin date;
  
  set varFechaIni = STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  set varFechaFin = LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'));   
  
  if varTipo = 'V' then
    set varSQLTipo = "D.subtotal";
  elseif varTipo = 'I' then
    set varSQLTipo = "D.igv";
  elseif varTipo = 'T' then
    set varSQLTipo = "D.total";
  end if;
  
  SET varNumDia = DAY(varFechaFin);
  SET @x = 1;
  REPEAT     
    SET varSQLCab = CONCAT(varSQLCab, "sum(case when day(V.fecha_emision)=", @x, "  then ", varSQLTipo, " end) as DIA_", LPAD(@x,2,'0'), ", ");
    SET @x = @x + 1; 
    UNTIL @x > varNumDia
  END REPEAT;
  
  if varVendedor is not null then
    set varCadVen = CONCAT(" and V.id_trabajador = ", varVendedor, " ");
  end if;
  
  SET @sql = CONCAT("select V.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "P.id_proveedor as CPRO, L.nombre as PROVEEDOR, ",
                    varSQLCab,
                    "sum(", varSQLTipo, ") as TOTAL " ,
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V     ON D.id_venta = V.id_venta ",
                    "inner join _sv_empresa E ON V.id_empresa = E.id_empresa ",
                    "inner join _sv_producto P  ON D.id_producto = P.id_producto ",
                    "inner join _sv_proveedor L ON P.id_proveedor = L.id_proveedor ",
                    "where V._estado = 'A' ",
                    "and V.estado   <> 'AN' ",
                    varCadVen,
                    "and V.id_empresa = ", varEmpresa, " ",
                    "and YEAR(V.fecha_emision) = '", varAnio, "' ",
                    "and MONTH(V.fecha_emision) = '", varMes, "' ",
                    "GROUP BY V.id_empresa, E.nombre, P.id_proveedor, L.nombre"); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1; 
END;