call spQuery_Report_AnalCompCob_Vendedor(1, NULL, '2012');

DROP PROCEDURE IF EXISTS spQuery_Report_AnalCompCob_Vendedor;
CREATE PROCEDURE spQuery_Report_AnalCompCob_Vendedor(
  varEmpresa    int,
  varProveedor  int,
	varAnio       varchar(4)
)
BEGIN
  DECLARE varCadPro  TEXT DEFAULT '';
  
  if varProveedor <> '' and varProveedor <> 'Todos' and varProveedor is not null then
    SET varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;

  SET @sql = CONCAT("select V.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "Ve.id_cargo as CTIP, T.nombre as TIPO, ",
                    "V.id_trabajador as CVEN, CONCAT(Ve.apellido_paterno, ' ', Ve.apellido_materno, ' ', Ve.nombre) as VENDEDOR, ",
                    "count(distinct case when month(V.fecha_emision)=1  then V.id_cliente end) as TOT_ENE, ",
                    "count(distinct case when month(V.fecha_emision)=2  then V.id_cliente end) as TOT_FEB, ",
                    "count(distinct case when month(V.fecha_emision)=3  then V.id_cliente end) as TOT_MAR, ",
                    "count(distinct case when month(V.fecha_emision)=4  then V.id_cliente end) as TOT_ABR, ",
                    "count(distinct case when month(V.fecha_emision)=5  then V.id_cliente end) as TOT_MAY, ",
                    "count(distinct case when month(V.fecha_emision)=6  then V.id_cliente end) as TOT_JUN, ",
                    "count(distinct case when month(V.fecha_emision)=7  then V.id_cliente end) as TOT_JUL, ",
                    "count(distinct case when month(V.fecha_emision)=8  then V.id_cliente end) as TOT_AGO, ",
                    "count(distinct case when month(V.fecha_emision)=9  then V.id_cliente end) as TOT_SET, ",
                    "count(distinct case when month(V.fecha_emision)=10 then V.id_cliente end) as TOT_OCT, ",
                    "count(distinct case when month(V.fecha_emision)=11 then V.id_cliente end) as TOT_NOV, ",
                    "count(distinct case when month(V.fecha_emision)=12 then V.id_cliente end) as TOT_DIC  "
                    "from _sv_venta V ",
                    "inner join _sv_empresa E ON V.id_empresa = E.id_empresa ",
                    "inner join _sv_trabajador Ve ON V.id_trabajador = Ve.id_trabajador ",
                    "left join _sv_cargo T ON Ve.id_cargo = T.id_cargo ",
                    "where V._estado = 'A' ",
                    "and V.estado   <> 'AN' ",
                    "and YEAR(V.fecha_emision) = '", varAnio, "' ",
                    "and V.id_empresa = ", varEmpresa, " ",
                    varCadPro,
                    "GROUP BY V.id_empresa, E.nombre, Ve.id_cargo, T.nombre, V.id_trabajador, CONCAT(Ve.apellido_paterno, ' ', Ve.apellido_materno, ' ', Ve.nombre)"); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1; 
END;