CALL spQuery_Registro_Ventas_Detalle(88077);

DROP PROCEDURE IF EXISTS spQuery_Registro_Ventas_Detalle;
CREATE PROCEDURE spQuery_Registro_Ventas_Detalle(  
	varVenta    int
  )
BEGIN 
  select C.id_venta as IDE,
  C.id_empresa as CEMP, E.nombre AS EMPRESA, 
  E.ruc as RUC_EMP, E.direccion as DIRE_EMP,
  C.id_agencia as CAGE, A.nombre as AGENCIA,
  C.id_punto_venta as CPUN, PV.nombre as PUNTOVENTA,
  date_format(C.fecha_emision,'%d/%m/%Y') AS EMISION,
  C.id_tipo_doc as CTIP,	T.nombre AS TIPO, concat(C.nro_serie,'-',C.nro_preimpreso) AS NDOC,
  C.nro_pedido AS PEDIDO, C.nro_guia AS GUIA, C.GLOSA,
	C.id_cliente as CCLI, P.nombre as CLIENTE, P.DNI, P.RUC, P.DIRECCION,
  C.id_ruta as CRUT, R.nombre AS RUTA,
	C.id_trabajador as CVEN, concat(ifnull(V.apellido_paterno,''),' ', ifnull(V.apellido_materno,''),' ', ifnull(V.nombre,'')) as VENDEDOR, 
	C.id_condicion as CCON, TC.nombre as CONDICION,
  C.id_lista AS CLIS, LP.nombre AS LISTA,
	C.TOTAL, ifnull(C.total,2) - ifnull(C.saldo,0) as PAGOS , C.SALDO,
  C.ESTADO AS CEST,
	CASE C.ESTADO WHEN 'CA' THEN 'CANCELADO'
                WHEN 'IN' THEN 'INGRESADO'
                WHEN 'AC' THEN 'INGRESADO'
                WHEN 'PP' THEN 'PARCIALMENTE PAGADO'
                WHEN 'AN' THEN 'ANULADO'
                WHEN 'AP' THEN 'APROVADO'
                ELSE 'INDETERMINADO'
  END AS ESTADO, 
  P.id_ubigeo AS UBI_CLI, 
  U.departamento AS DEP_CLI, 
  