call spQuery_Registro_Pedidos_Contenido(12305);

DROP PROCEDURE IF EXISTS spQuery_Registro_Pedidos_Contenido;
CREATE PROCEDURE spQuery_Registro_Pedidos_Contenido(  
	varPedido    int
  )
BEGIN
  DECLARE varEmpresa, varAlmacen int;
  select id_empresa, id_almacen
  into varEmpresa, varAlmacen
  from _sv_pedido
  where id_pedido = varPedido;
  
  select D.id_producto AS CPRO, 
  CONCAT(CAST(CASE WHEN D.id_tipo='B' THEN '(B) ' ELSE '' END AS CHAR), CAST(A.descripcion AS CHAR)) AS PRODUCTO, 
  D.id_tipo as TIPO,
  D.id_um as UM,
  D.PRECIO,
  D.CANTIDAD_PED AS CANTIDAD,
  D.TOTAL,
  D.LOTE,
  DATE_FORMAT(D.fecha_vencimiento,'%d/%m/%Y') AS FVENCE,
  (select cantidad 
   from _sv_kardex K
   where id_empresa = varEmpresa
   and id_almacen   = varAlmacen
   and K.id_producto = D.id_producto) as STOCK
  from _sv_pedido_detalle D
  inner join _sv_producto A ON D.id_producto = A.id_producto
  where D.id_pedido  = varPedido;
END;