CALL spQuery_Registro_Pedidos_Cabecera(42438);

DROP PROCEDURE IF EXISTS spQuery_Registro_Pedidos_Cabecera;
CREATE PROCEDURE spQuery_Registro_Pedidos_Cabecera(  
	varPedido    int
  )
BEGIN 
  select C.id_pedido as IDE,
  C.id_empresa as CEMP, L.nombre as EMPRESA,
  C.id_agencia as CAGE, A.nombre as AGENCIA,
  C.id_almacen as CALM, K.nombre AS ALMACEN,
  date_format(C.fecha_pedido,'%d/%m/%Y') AS FECHA,
  C.id_cliente as CCLI, P.nombre as CLIENTE, 
	C.id_trabajador as CVEN, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ', V.nombre) as VENDEDOR, 
  C.id_tipo_doc as CTIP, TD.nombre as TIPODOC,
	C.id_condicion as CCON, TC.nombre as CONDICION,
  C.id_lista as CLIS, Li.nombre as LISTA,
	C.SUBTOTAL, C.IGV, C.TOTAL,
	case when C.estado = 'IN' then 'INGRESADO'
       when C.estado = 'AN' then 'ANULADO'
       when C.estado = 'FA' then 'FACTURADO'
  end as ESTADO, 
  UPPER(UC.usuario) as USER_CREATE,
  date_format(C._date_create,'%d/%m/%Y %h:%m:%s %p') AS DATE_CREATE,
  UPPER(UU.usuario) AS USER_UPDATE,
  date_format(C._date_update,'%d/%m/%Y %h:%m:%s %p') AS DATE_UPDATE,
  C.nro_pedido AS PEDIDO, C.GLOSA, Li.monto_minimo as MMINIMO,
  P.DNI, P.RUC,
  P.direccion as DIRE_CLI, 
  P.id_ruta as CRUT, R.nombre as RUTA
	from _sv_pedido C
  inner join _sv_empresa L  ON C.id_empresa = L.id_empresa
  inner join _srh_agencia A ON C.id_agencia = A.id_agencia
  inner join _sv_almacen K  ON C.id_almacen = K.id_almacen
	inner join _sv_cliente P  ON C.id_cliente = P.id_cliente
	inner join _sv_trabajador V ON C.id_trabajador = V.id_trabajador
	inner join _sv_tipo_condicion TC ON C.id_condicion = TC.id_condicion
  inner join _sv_tipo_doc_venta TD ON C.id_tipo_doc = TD.id_tipo_doc
  inner join _sv_lista Li   ON C.id_lista = Li.id_lista
  inner join _sv_ruta R     ON C.id_ruta = R.id_ruta
  left join _sys_usuario UC  ON C._user_create = UC.id_usuario
  left join _sys_usuario UU  ON C._user_update = UU.id_usuario
	where C._estado = 'A'
	AND C.id_pedido  = varPedido;
END;