CALL spQuery_Registro_Compras_Detalle(1);

DROP PROCEDURE IF EXISTS spQuery_Registro_Compras_Detalle;
CREATE PROCEDURE spQuery_Registro_Compras_Detalle(  
	varCompra    int
  )
BEGIN
  select C.id_compra as IDE,
  C.id_empresa as CEMP, E.nombre as EMPRESA,
  date_format(C.fecha_emision,'%d/%m/%Y') AS EMISION,
  date_format(C.fecha_movimiento,'%d/%m/%Y') AS MOVIMIENTO,
  C.id_proveedor AS CPRO, P.nombre AS PROVEEDOR,
  C.id_condicion as CCON, TC.nombre as CONDICION,
  C.id_tipo_doc as CTIP, TD.nombre as TIPO,
  C.nro_documento AS NDOC,
  C.SUBTOTAL, C.IGV, C.TOTAL, C.SALDO
  from _sv_compra C
  inner join _sv_proveedor P ON C.id_proveedor = P.id_proveedor
  inner join _sv_tipo_doc_compra TD ON C.id_tipo_doc = TD.id_tipo_doc
  inner join _sv_tipo_condicion TC ON C.id_condicion = TC.id_condicion
  inner join _sv_empresa E ON C.id_empresa = E.id_empresa
  where C.id_compra = varCompra;
END;