call spQuery_Registro_Cambios_Devolucion(245, NULL,'2011-05-02', '2011-05-02');

DROP PROCEDURE IF EXISTS spQuery_Registro_Cambios_Devolucion;
CREATE PROCEDURE spQuery_Registro_Cambios_Devolucion(  
	varCliente    int,
  varVendedor   int,
	varFechaIni   date,
	varFechaFin   date
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadCliente, varCadVend varchar(100) DEFAULT '';
  
  IF IFNULL(varCliente,0) <> 0 THEN
    SET varCadCliente = CONCAT(" and C.id_cliente = ", varCliente, " ");  
  END IF;
  
  IF IFNULL(varVendedor,0) <> 0 THEN
    SET varCadVend = CONCAT(" and C.id_vendedor = ", varVendedor, " ");  
  END IF;
  
  IF varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and C.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and C.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  set @sql = CONCAT("select C.id_venta as CMOV, date_format(C.fecha_emision,'%d/%m/%Y') AS FECHA, ",
                    "T.abrev as TIPDOC, C.nro_documento as DOCUMENTO, ",
                    "CASE WHEN C.estado='AC' THEN 'ACTIVO' ",
                    "     WHEN C.estado='AN' THEN 'ANULADO' ",
                    "     WHEN C.estado='PP' THEN 'PARCIALMENTE PAGADO' ",
                    "     WHEN C.estado='CA' THEN 'CANCELADO' ",
                    "     ELSE 'OTROS' ",                    
                    "END AS ESTADO, ",
                    "C.id_cliente as CCLI, P.nombre as CLIENTE, ",
                    "C.id_vendedor as CVEN, V.nombre as VENDEDOR, ",
                    " C.TOTAL, ",
                    "date_format(C._date_update,'%d/%m/%Y %H:%m:%s') as SISTEMA ",
                    "from _sv_venta C ",
                    "inner join _sv_cliente P ON C.id_cliente = P.id_cliente ",
                    "left join _sv_vendedor V ON C.id_vendedor = V.id_vendedor ",
                    "inner join _sv_tipo_doc_venta T ON C.id_tipo_doc = T.id_tipo_doc ",
                    "where C._estado='A' ",
                    "and C.id_tipo_doc = 5 ",
                    "and C.estado <> 'AN' ",
                    varCadCliente, varCadVend, varCadFechaIni, varCadFechaIni,
                    "order by C.id_venta");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;