CALL spQuery_Planilla_Mensual_Boleta_Descuentos(26,13,8,1080);

DROP PROCEDURE IF EXISTS spQuery_Planilla_Mensual_Boleta_Descuentos;
CREATE PROCEDURE spQuery_Planilla_Mensual_Boleta_Descuentos(
  varPeriodo    int,  
  varAgencia    int,
  varEmpresa    int,
  varTrabajador int
)
BEGIN 

  select 
  CASE WHEN IFNULL(TI.id_padre_bol,0)=0  THEN TI.id_ingreso ELSE TI.id_padre_bol END AS CING,
  LOWER(TIP.concepto) AS INGRESO,
  CASE WHEN IFNULL(TD.id_padre_bol,0)=0  THEN TD.id_ingreso ELSE TD.id_padre_bol END AS CDES,
  LOWER(TDP.concepto) AS DESCUENTO,
  sum(PD.MONTO) as MONTO
  from _bp_planilla_detalle PD   
  left join _pdt_tipo_ingresos TI  ON PD.id_tipo_ingreso = TI.id_ingreso
  left join _pdt_tipo_ingresos TIP ON CASE WHEN IFNULL(TI.id_padre_bol,0)=0  THEN TI.id_ingreso ELSE TI.id_padre_bol END = TIP.id_ingreso
  left join _pdt_tipo_ingresos TD  ON PD.id_tipo_descuento = TD.id_ingreso
  left join _pdt_tipo_ingresos TDP ON CASE WHEN IFNULL(TD.id_padre_bol,0)=0  THEN TD.id_ingreso ELSE TD.id_padre_bol END = TDP.id_ingreso
  where PD._estado    <> 'X'  
  and PD.id_tipo_ingreso <> 118
  AND id_periodo        = varPeriodo
  and PD.id_empresa     = varEmpresa
  and PD.id_agencia     = varAgencia
  and PD.id_trabajador  = varTrabajador       
  GROUP BY 
  CASE WHEN IFNULL(TI.id_padre_bol,0)=0  THEN TI.id_ingreso ELSE TI.id_padre_bol END,
  TIP.concepto,
  CASE WHEN IFNULL(TD.id_padre_bol,0)=0  THEN TD.id_ingreso ELSE TD.id_padre_bol END,
  TDP.concepto;
END;


select 
  PD.id_tipo_ingreso,
  PD.id_tipo_descuento,
  PD.MONTO,
  PD._estado
  from _bp_planilla_detalle PD   
  where 
  id_periodo        = 26
  and PD.id_empresa     = 8
  and PD.id_agencia     = 13
  and PD.id_trabajador  = 379;