call spQuery_Planilla_Cabecera(12);

DROP PROCEDURE IF EXISTS spQuery_Planilla_Cabecera;
CREATE PROCEDURE spQuery_Planilla_Cabecera(
  varPlanilla int
  )
BEGIN
  select P.id_planilla as CPLA, P.nombre as PLANILLA,
	P.id_periodo_pago as CPEP, PP.nombre as PERPAGO,
	P.id_periodo_afp AS CPEA, PA.nombre as PERAFP,
	P.id_tipo_periodicidad as CPER, PE.nombre as PERIODICIDAD,
	P.id_tipo_planilla as CTIP, T.nombre as TIPO,
	date_format(P.fecha_inicio,'%d/%m/%Y') as FINI,
	date_format(P.fecha_fin,'%d/%m/%Y') as FFIN,
	P.dias_trabajados as DIAS
	from _srh_planilla P
	inner join _srh_periodo_pago PP ON P.id_periodo_pago = PP.id_periodo_pago
	inner join _srh_periodo_afp PA  ON P.id_periodo_afp = PA.id_periodo_afp
	inner join _srh_tipo_periodicidad PE ON P.id_tipo_periodicidad = PE.id_tipo_periodicidad
	inner join _srh_tipo_planilla T ON P.id_tipo_planilla = T.id_tipo_planilla
	where P.id_planilla = varPlanilla;
END;

