call spQuery_PeriodoPago(NULL,NULL,'FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_PeriodoPago;
CREATE PROCEDURE spQuery_PeriodoPago(
  varCodigo int,
	varNombre varchar(80),
  varEstado char(1),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadEst  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and P.id_periodo_pago = ", varCodigo, " ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and P.nombre LIKE '%", varNombre, "%' ");
  end if;
  if ifnull(varEstado,'') <> '' then
    set varCadEst = CONCAT(" and P.estado = '", varEstado, "' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'P._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'P._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;

	set @sql = CONCAT("select P.id_periodo_pago as CPER, P.nombre as PERIODO, ",
                    "P.id_tipo_periodicidad as CTIP, T.nombre as TIPO, ",
                    "date_format(P.fecha_inicio,'%d/%m/%Y') as INICIO, ",
                    "date_format(P.fecha_fin,'%d/%m/%Y') as FIN, ",
                    "P.dias_periodo as DIAS, P.dias_laborables as LABORABLES, P.dias_feriados as FERIADOS, ",
                    "CASE WHEN P.estado='A' then 'ABIERTO' ELSE 'CERRADO' END AS ESTADO, ",
                    "date_format(P._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(P._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _srh_periodo_pago P ",
                    "inner join _srh_tipo_periodicidad T ON P.id_tipo_periodicidad = T.id_tipo_periodicidad ",
                    "left join _sys_usuario UN ON P._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON P._user_update = UU.id_usuario ",
                    "where P._estado='A' ",
	                  varCadCod, varCadNom, varCadEst,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;

