call spQuery_Matriz_IP(NULL, 2, NULL, NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Matriz_IP;
CREATE PROCEDURE spQuery_Matriz_IP(
  varCodigo int,
  varArea   int,
	varNombre varchar(80),
  varEstado char(1),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadEst, varCadAre text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_matriz = ", varCodigo, " ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  if ifnull(varEstado,'') <> '' then
    set varCadEst = CONCAT(" and M.estado = '", varEstado, "' ");
  end if;
  if ifnull(varArea,'') <> '' then
    set varCadAre = CONCAT(" and M.id_area = '", varArea, "' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'A._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'A._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select A.CMAT, A.MATRIZ, A.ABREV, A.CARE, A.AREA, A.BASE, ",
                    "case when B.VERIF<>100 then 'ERROR' else 'CORRECTO' end as VERIFICAR, ",
                    "A.ESTADO,  ",
                    "date_format(A._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(A._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "USER_CREADO, USER_MODIFI ",
                    "FROM  ",
                    "  ( ",
                    "  select M.id_matriz as CMAT, M.nombre as MATRIZ, M.ABREV, ",
                    "  M.id_area as CARE, A.nombre as AREA, ",
                    "  M.BASE, CASE WHEN M.estado='A' THEN 'ACTIVO' ELSE 'INACTIVO' END AS ESTADO, ",
                    "  M._date_create, ",
                    "  M._date_update, ",
                    "  UPPER(UN.usuario) as USER_CREADO, ",
                    "  UPPER(UU.usuario) as USER_MODIFI ",
                    "  from _sind_matriz M ",
                    "  inner join _srh_area a ON M.id_area = A.id_area ",
                    "  left join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "  left join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "  where M._estado='A' ",
                    varCadCod, varCadNom, varCadEst, varCadAre,
                    "  ) A ",
                    "LEFT JOIN ",
                    "  ( ",
                    "  select id_matriz AS CMAT, avg(pormat) AS VERIF ",
                    "  from ",
                    "    ( ",
                    "    select id_matriz, padre, sum(porcentaje) as pormat ",
                    "    from _sind_matriz_detalle ",
                    "    where ifnull(porcentaje,0)<>0 ",
                    "    group by id_matriz, padre ",
                    "    ) X ",
                    "  group by id_matriz ",
                    "  ) B ",
                    "ON A.CMAT = B.CMAT ",	                  
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;

