call spQuery_Logisitica_Inventario_Valorizado('U',1,NULL, NULL, NULL);
call spQuery_Logisitica_Inventario_Valorizado('T', 1, 1, NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Logisitica_Inventario_Valorizado;
CREATE PROCEDURE spQuery_Logisitica_Inventario_Valorizado(
  varTipoProducto char(1),
  varEmpresa      int,
  varAlmacen      int,
  varLinea        varchar(10),
  varFamilia      varchar(10),
  varSubFamilia   varchar(10)
  )
BEGIN
  DECLARE varCadTipoProd, varCadEmp, varCadAlm, varCadLin, varCadFam, varCadSub text default '';
  
  if varTipoProducto <> 'T' then
    set varCadTipoProd = CONCAT(" and K.cantidad   > 0 ");
  end if;
  if varEmpresa is not null then
    set varCadEmp = CONCAT(" and K.id_empresa = ", varEmpresa, " ");
  end if;
  if varAlmacen is not null then
    set varCadAlm = CONCAT(" and K.id_almacen = ", varAlmacen, " ");
  end if;
  if varLinea is not null then
    set varCadLin = CONCAT(" and P.id_tipo = ", varLinea, " ");
  end if;
  if varFamilia is not null then
    set varCadFam = CONCAT(" and P.id_familia = ", varFamilia, " ");
  end if;
  if varSubFamilia is not null then
    set varCadSub = CONCAT(" and P.id_sub_familia = ", varSubFamilia, " ");
  end if;
  
  SET @sql = CONCAT("select ",
                    "P.id_tipo as CTIP, T.nombre as TIPO, ",
                    "P.id_familia as CFAM, F.nombre as FAMILIA, ",
                    "P.id_sub_familia as CSUB, S.nombre as SUB_FAMILIA, ",
                    "P.id_producto as CPRO,  ",
                    "P.descripcion as PRODUCTO, ", 
                    "P.id_um_stock as UM, ",
                    "CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END as STOCK, ",
                    
                    "P.precio_compra as PC, ",
                    
                    "(select min(precio) from _sv_lista_producto L ",
                    " where L._estado='A' ",
                    " and L.id_producto=P.id_producto ",
                    " and L.id_um = P.id_um_stock) AS PV, ",
                    
                    " ROUND((CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END)*P.precio_compra,2) AS TTC, ",
                    
                    " ROUND((CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END)*",
                    " IFNULL((select min(precio) from _sv_lista_producto L ",
                    " where L.id_lista=1 and L._estado='A' ",
                    " and L.id_producto=P.id_producto ",
                    " and L.id_um = P.id_um_stock),0),2) AS TTV, ",
                    
                    " ROUND((CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END)*",
                    " IFNULL((select min(precio) from _sv_lista_producto L ",
                    " where L.id_lista=1 and L._estado='A' ",
                    " and L.id_producto=P.id_producto ",
                    " and L.id_um = P.id_um_stock),0),2) - ",
                    " ROUND((CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END)*P.precio_compra,2) AS MARGEN ",
                    
                    "from _sv_kardex K ",
                    "inner join _sv_producto P on K.id_producto = P.id_producto ",                    
                    "inner join _sv_tipo T    ON P.id_tipo = T.id_tipo ",
                    "inner join _sv_familia F ON P.id_familia = F.id_familia ",
                    "inner join _sv_sub_familia S ON P.id_sub_familia = S.id_sub_familia ",
                    "where P._estado  = 'A' ",
                    "and K._estado    = 'A' ",
                    varCadTipoProd, varCadEmp, varCadAlm, varCadLin, varCadFam, varCadSub,
                    "order by T.nombre, F.nombre, S.nombre, P.descripcion;");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
