call spQuery_Logisitica_Inventario_Actual_Vendedor('U',1,NULL);

DROP PROCEDURE IF EXISTS spQuery_Logisitica_Inventario_Actual_Vendedor;
CREATE PROCEDURE spQuery_Logisitica_Inventario_Actual_Vendedor(
  varTipoProducto char(1),
  varAlmacen      int,
  varProveedor    int
  )
BEGIN
  DECLARE varCadTipoProd, varCadProveedor text default '';
  
  if varTipoProducto <> 'T' then
    set varCadTipoProd = CONCAT(" and K.cantidad   > 0 ");
  end if;
  
  if varProveedor <> '' and varProveedor is not null then
    set varCadProveedor = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;
  
  
  SET @sql = CONCAT("select P.id_proveedor as CLIN, ",
                    "L.nombre as LINEA, ",
                    "P.id_tipo as CTIP, T.nombre as TIPO, ",
                    "P.id_familia as CFAM, F.nombre as FAMILIA, ",
                    "P.id_sub_familia as CSUB, S.nombre as SUB_FAMILIA, ",
                    "P.id_producto as CPRO,  ",
                    "P.descripcion as PRODUCTO, ", 
                    "P.id_um_stock as UM, ",
                    "CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END as STOCK ",
                    "from _sv_kardex K ",
                    "inner join _sv_producto P on K.id_producto = P.id_producto ",
                    "inner join _sv_proveedor L on P.id_proveedor = L.id_proveedor ",
                    "inner join _sv_tipo T    ON P.id_tipo = T.id_tipo ",
                    "inner join _sv_familia F ON P.id_familia = F.id_familia ",
                    "inner join _sv_sub_familia S ON P.id_sub_familia = S.id_sub_familia ",
                    "where P._estado  = 'A' ",
                    "and K._estado    = 'A' ",
                    "and K.id_almacen =  ", varAlmacen," ",
                    varCadTipoProd, varCadProveedor,
                    "order by P.id_proveedor, T.nombre, F.nombre, S.nombre, P.id_producto;");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
