call spQuery_Lista_Regimen('T', NULL,NULL);

DROP PROCEDURE IF EXISTS spQuery_Lista_Regimen;
CREATE PROCEDURE spQuery_Lista_Regimen(
  varTipo     varchar(1),
  varCodigo   varchar(2),
  varNombre   varchar(80)
  )
BEGIN 
  DECLARE varCadCod, varCadNom, varCadTip text default '';
  if ifnull(varCodigo,'')<>'' then
    set varCadCod = CONCAT(" and T.id_regimen = ", varCodigo, " ");
  end if;
  
  if ifnull(varNombre,'')<>'' then
    set varCadNom = CONCAT(" and T.nombre LIKE '%", varNombre, "%' ");
  end if;
  
  if varTipo = 'P' then
    set varCadTip = CONCAT(" and T.flag_privado = 'S' ");
  elseif varTipo = 'N' then
    set varCadTip = CONCAT(" and T.flag_publico = 'S' ");
  elseif varTipo = 'O' then
    set varCadTip = CONCAT(" and T.flag_otros = 'S' ");
  else
    set varCadTip = "";
  end if;
  
  SET @sql = CONCAT("select T.id_regimen, T.nombre, T.abrev ",
                    "from _srh_regimen_pension T ",
                    "where T._estado = 'A' ",
                    varCadCod, varCadNom, varCadTip,
                    "order by T.id_regimen; ");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;