call spQuery_Lista_Habitacion_Tarifario(NULL,NULL);

DROP PROCEDURE IF EXISTS spQuery_Lista_Habitacion_Tarifario;
CREATE PROCEDURE spQuery_Lista_Habitacion_Tarifario(
  varEmpresa  int,
  varSegmento int
  )
BEGIN 
  select H.id_habitacion as CHAB, CONCAT(H.numero, ' - ', T.nombre, ' - ', P.nombre) AS HABITACION
  from _sh_habitacion H
  inner join _sh_tipo_habitacion T ON H.id_tipo_habitacion = T.id_tipo_habitacion
  inner join _sh_piso P ON H.id_piso = P.id_piso
  where H._estado = 'A'
  and H.id_empresa = varEmpresa
  and H.id_habitacion not in (select id_habitacion 
                              from _sh_tarifario X
                              where X._estado   = 'A' 
                              and X.id_empresa  = varEmpresa
                              and X.id_segmento = varSegmento)
  ORDER BY H.numero;
END;