call spQuery_Impresion_Cambio('002-0011014', '002-0011014', '2011-11-03');

DROP PROCEDURE IF EXISTS spQuery_Impresion_Cambio;
CREATE PROCEDURE spQuery_Impresion_Cambio(  
	varCambioIni  varchar(12), 
  varCambioFin  varchar(12),
  varFechaEmi   date
  )
BEGIN  
  select C.id_venta as IDE, date_format(C.fecha_emision,'%d/%m/%Y') AS FECHA,
  CONCAT(T.abrev,' ', C.nro_documento) as DOCUMENTO,
  C.id_condicion as CCON, TC.nombre as CONDICION,
  C.ESTADO,
  C.id_tipo_doc as CTIP,
  C.id_cliente as CCLI, P.nombre as CLIENTE,
  C.id_vendedor as CVEN, V.nombre as VENDEDOR,
  P.id_ruta as CRUT, R.nombre as RUTA,
  C.nro_pedido as PEDIDO, C.nro_guia as GUIA,
  C.TOTAL,
  date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO,
  date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI,
  UPPER(UN.usuario) as USER_CREADO,
  UPPER(UU.usuario) as USER_MODIFI
  from _sv_venta C
  inner join _sv_cliente P ON C.id_Cliente = P.id_Cliente
  left join _sv_ruta R ON P.id_ruta = R.id_ruta
  inner join _sv_tipo_doc_venta T ON C.id_tipo_doc = T.id_tipo_doc
  inner join _sv_tipo_condicion TC ON C.id_condicion = TC.id_condicion
  inner join _sv_vendedor V ON C.id_vendedor = V.id_vendedor
  inner join _sys_usuario UN ON C._user_create = UN.id_usuario
  inner join _sys_usuario UU ON C._user_update = UU.id_usuario
  where C._estado='A'
  and C.id_tipo_doc = 5
  and C.fecha_emision = varFechaEmi
  and C.nro_documento >= varCambioIni
  and C.nro_documento <= varCambioFin
  order by C.id_venta;
END;