call spQuery_Habitacion(NULL, NULL, NULL, NULL, 1, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Habitacion;
CREATE PROCEDURE spQuery_Habitacion(
	varCodigo   varchar(10),
	varNombre   varchar(80),
	varEmpresa  int,
  varTipo     int,
  varUsuario  int,
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadEmp, varCadTip TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and H.id_habitacion = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and H.numero like '%", varNombre,"%' ");
  end if;
  if varEmpresa <> '' and varEmpresa is not null then
    set varCadEmp = CONCAT(" and H.id_empresa = ", varEmpresa," ");
  end if;
  if varTipo <> '' and varTipo is not null then
    set varCadTip = CONCAT(" and H.id_tipo_habitacion = '", varTipo,"' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select H.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "H.id_habitacion as CHAB, H.NUMERO, ",
                    "H.id_tipo_habitacion as CTIP, T.nombre as TIPO, ",
                    "H.id_piso as CPIS, P.nombre as PISO, ",
                    "H.num_personas AS CAPACIDAD, H.num_camas AS CAMAS, ",
                    "CASE WHEN H.flag_tv      = 'S' THEN 'SI' ELSE 'NO' END AS TV, ",
                    "CASE WHEN H.flag_aire    = 'S' THEN 'SI' ELSE 'NO' END AS AIRE, ",
                    "CASE WHEN H.flag_terma   = 'S' THEN 'SI' ELSE 'NO' END AS TERMNA, ",
                    "CASE WHEN H.flag_radio   = 'S' THEN 'SI' ELSE 'NO' END AS RADIO, ",
                    "CASE WHEN H.flag_friobar = 'S' THEN 'SI' ELSE 'NO' END AS FRIOBAR, ",
                    "CASE WHEN H.flag_jacuzzi = 'S' THEN 'SI' ELSE 'NO' END AS FRIOBAR, ",
                    "H.PRECIO, ",
                    "CASE WHEN H.estado = 'A' THEN 'ACTIVO' ELSE 'INACTIVO' END AS ESTADO, ",
                    "date_format(H._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(H._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UC.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sh_habitacion H ",
                    "inner join _sv_empresa E ON H.id_empresa = E.id_empresa ",
                    "inner join _sh_tipo_habitacion T ON H.id_tipo_habitacion = T.id_tipo_habitacion ",
                    "inner join _sh_piso P ON H.id_piso = P.id_piso ",
                    "left join _sys_usuario UC ON H._user_create = UC.id_usuario ",
                    "left join _sys_usuario UU ON H._user_update = UU.id_usuario ",
                    "WHERE H._estado = 'A' ",
                    "AND H.id_empresa IN (select distinct id_empresa from _sys_usuario_almacen where id_usuario=1)",
                    varCadCod, varCadNom, varCadEmp, varCadTip,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
