call spQuery_Estado_Cuenta_CxC(1, '2012-07-25', '2012-08-30');

DROP PROCEDURE IF EXISTS spQuery_Estado_Cuenta_CxC;
CREATE PROCEDURE spQuery_Estado_Cuenta_CxC(
  varEmpresa    int,
  varCliente    int,
  varFechaIni   date,
  varFechaFin   date
  )
BEGIN
  DECLARE varSaldoIni, varVenta, varPagos, varVentaIni   double default 0;
  DECLARE varQuery      text;
  DECLARE varIde        int  DEFAULT 1;
  DECLARE varSaldo      double DEFAULT 0;
  DECLARE varCurTipoMov varchar(5);
  DECLARE varCurFecha   date;
  DECLARE varCurDocu    varchar(50);
  DECLARE varCurDesc    text;
  DECLARE varCurDebe, varCurHaber, varCurSaldo  double;
  DECLARE varCurVenta   int;   
  
  DECLARE done INT DEFAULT 0;
  DECLARE curMov CURSOR FOR 
      select M.tipo_mov, M.fecha, 
      CASE WHEN M.tipo_mov='INI' THEN 'SALDO/INICIAL'
          WHEN M.tipo_mov='VEN' THEN CONCAT(TV.abrev,'/',V.nro_serie,'-',V.nro_preimpreso) 
          WHEN M.tipo_mov='PAG' AND M.id_pago_cxc is NULL THEN 'PAGO/CONTADO'
          WHEN M.tipo_mov='PAG' AND M.id_pago_cxc is NOT NULL THEN CONCAT(TP.abrev,'/',P.nro_doc_pago) 
      END AS documento,
      CASE WHEN M.tipo_mov='INI' THEN CONCAT('SALDO INICIAL AL ', CAST(DATE_FORMAT(M.fecha,'%d/%m/%Y') AS CHAR))
          WHEN M.tipo_mov='PAG' AND M.id_pago_cxc is NULL THEN CONCAT('PAGO AL CONTADO DE ', TV.abrev,'/',V.nro_serie,'-',V.nro_preimpreso)
          WHEN M.tipo_mov='PAG' AND M.id_pago_cxc is NOT NULL THEN CONCAT(UPPER(TP.nombre), ' DE ', TV.abrev,'/',V.nro_serie,'-',V.nro_preimpreso)
      END AS descripcion,
      CASE WHEN M.tipo_mov ='VEN' THEN M.monto END as debe,
      CASE WHEN M.tipo_mov IN ('PAG','DEV') THEN M.monto END as haber,
      CASE WHEN M.tipo_mov ='INI' THEN M.monto END as saldo,
      M.id_venta
      from _sv_movimiento_cuenta_cxc M
      left join _sv_venta V     ON M.id_venta = V.id_venta
      left join _sv_tipo_doc_venta TV ON V.id_tipo_doc = TV.id_tipo_doc
      left join _sv_pago_cxc P  ON M.id_pago_cxc = P.id_pago_cxc
      left join _sv_forma_pago TP  ON P.id_forma_pago = TP.id_forma_pago
      where M._estado   = 'A'
      and M.id_empresa  = varEmpresa
      and M.id_cliente  = varCliente
      and M.fecha      >= varFechaIni
      order by M.fecha, M.id_mov_cuenta;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  /* 
  TIPOS DE MOVIMIENTOS 
  ====================
  INI : SALDO INICIAL (SALDO)
  VEN : VENTAS        (DEBE)
  PAG : PAGOS         (HABER)
  DEV : DEVOLUCIONES  (HABER)
  */
  /* CREAMOS TABLA TEMPORAL */
  DROP TEMPORARY TABLE IF EXISTS _sv_temp_estado_cxc;
  CREATE TEMPORARY TABLE IF NOT EXISTS _sv_temp_estado_cxc
    (
    ide         int,    
    fecha       date,
    documento   varchar(50),
    descripcion text,
    debe        double,
    haber       double,
    saldo       double
    );
  