call spQuery_Concepto_Remunerativo('P', '',NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Concepto_Remunerativo;
CREATE PROCEDURE spQuery_Concepto_Remunerativo(
  varTipo   char(1),
  varCodigo varchar(2),
	varNombre varchar(80),  
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadTip  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and C.id_concepto LIKE '%", varCodigo, "%' ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and C.nombre LIKE '%", varNombre, "%' ");
  end if;
  
  if varTipo = 'P' then
    set varCadTip = " and C.id_tipo_concepto in ('01','02','03','04','05','06','07','08','09','10') ";
  elseif varTipo = 'E' then
    set varCadTip = " and C.id_tipo_concepto not in ('01','02','03','04','05','06','07','08','09','10') ";
  else
    set varCadTip = " ";
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'C._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'C._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select C.id_concepto as CCON, C.nombre as CONCEPTO, C.ABREV, ",
                    "C.id_tipo_concepto as CTIP, T.nombre as TIPO, ",              
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _srh_concepto_remunerativo C ",
                    "inner join _srh_tipo_concepto T ON C.id_tipo_concepto = T.id_tipo_concepto ",
                    "left join _sys_usuario UN ON C._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado='A' ",
	                  varCadCod, varCadNom, varCadTip,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;