DROP PROCEDURE IF EXISTS spQuery_Comision_Vendedor;
CREATE PROCEDURE spQuery_Comision_Vendedor_Detalle(	
	varFechaIni date,
  varFechaFin date
)
BEGIN
  select V.id_vendedor as CVEN, P.nombre as VENDEDOR,
  SUM(D.subtotal) as SUBTOTAL,
  SUM(D.igv) AS IGV,
  SUM(D.total) AS TOTAL,
  SUM(ifnull(D.subtotal,0)*ifnull(L.peso,0)/100) as COMISION
  from _sv_venta_detalle D
  inner join _sv_venta V ON D.id_venta = V.id_venta
  inner join _sv_vendedor P ON V.id_vendedor = P.id_vendedor
  inner join _sv_lista L ON V.id_lista = L.id_lista
  where V.estado <> 'AN'
  and V._estado = 'A'
  and D._estado = 'A'
  and V.fecha_emision >= varFechaIni
  and V.fecha_emision <= varFechaFin
  GROUP BY V.id_vendedor, P.nombre;
END;