call spQuery_Combo_Proveedor_Meta(1, 'Ninguno','Ninguno');

DROP PROCEDURE IF EXISTS spQuery_Combo_Proveedor_Meta;
CREATE PROCEDURE spQuery_Combo_Proveedor_Meta(
  varEmpresa  int,
  varAnio     varchar(4),
  varMes      varchar(2)
  )
BEGIN 
  select id_proveedor, nombre 
  from _sv_proveedor
  where _estado='A' and estado = 'A'
  and id_proveedor not in (
                          select id_proveedor
                          from _sv_metas 
                          where id_empresa = varEmpresa
                          and id_anio      = varAnio
                          and id_mes       = varMes
                          group by id_proveedor
                          having count(id_trabajador) >= (select count(id_trabajador) 
                                                        from _sv_trabajador
                                                        where _estado = 'A'
                                                        and id_tipo_trabajador in (1,2)
                                                        and estado = 'A')
                          )
  order by nombre;
END;