call spQuery_Avance_Ventas_Vendedor_Proveedor('2011','08',2, '2011-08-01','2011-08-15');

DROP PROCEDURE IF EXISTS spQuery_Avance_Ventas_Vendedor_Proveedor;
CREATE PROCEDURE spQuery_Avance_Ventas_Vendedor_Proveedor( 
	varAnio       varchar(4),
  varMes        varchar(4),
  varProveedor  int,
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN
  DECLARE varDiaAcum, varDiaUtil  double;
  
  SET varDiaAcum = spFuncion_DiasAcumulados(varAnio, varMes);
  SET varDiaUtil = spFuncion_DiasUtiles(varAnio,varMes);
  
  
  select A.CVEN, A.VENDEDOR, B.META, VENTA, ROUND(VENTA/META*100,2) AS PORC_AVANCE,
  round(VENTA/varDiaAcum*varDiaUtil,2) as TENDENCIA,
  round((VENTA/varDiaAcum*varDiaUtil)/META*100,2) AS PORC_TENDENCIA
  from
    (
    select C.id_vendedor as CVEN, V.nombre as VENDEDOR,
    SUM(D.subtotal) as VENTA
    from _sv_venta_detalle D
    inner join _sv_venta C ON D.id_venta = C.id_venta
    inner join _sv_vendedor V ON C.id_vendedor = V.id_vendedor
    inner join _sv_producto P ON D.id_producto = P.id_producto
    where C._estado = 'A'
    and D._estado   = 'A'
    and C.estado   <> 'AN'
    and P.id_proveedor = varProveedor
    -- and C.id_motivo_rechazo = 0
    and C.fecha_emision    >= varFechaIni
    and C.fecha_emision    <= varFechaFin
    GROUP BY C.id_vendedor, V.nombre
    ) A
  left join
    (
    select M.id_vendedor as CVEN, SUM(M.monto) as META
    from _sv_metas M
    where M.id_anio    = varAnio
    and M.id_mes       = varMes
    and M.id_proveedor = varProveedor
    GROUP BY M.id_vendedor
    ) B 
  on A.CVEN = B.CVEN;
END;