call spQuery_Avance_Rebotes_Cliente(1, '2012-09-01', '2012-09-17', NULL, 6904, NULL,NULL);

DROP PROCEDURE IF EXISTS spQuery_Avance_Rebotes_Cliente;
CREATE PROCEDURE spQuery_Avance_Rebotes_Cliente(
  varEmpresa    int,
	varFechaIni   date,
	varFechaFin   date,
  varVendedor   int,
  varCliente    int,
  varField      varchar(60),
  varOrder      varchar(5)
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadVendedor, varCadCliente TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  IF varVendedor <> '' AND varVendedor IS NOT NULL THEN
    SET varCadVendedor = CONCAT(" and V.id_trabajador = ", varVendedor, " ");  
  END IF;
  
  IF varCliente <> '' AND varCliente IS NOT NULL THEN
    SET varCadCliente = CONCAT(" and V.id_cliente = ", varCliente, " ");  
  END IF;
  
  IF varFechaIni <> '' and varFechaIni <> '0000-00-00' and varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and V.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin <> '' and varFechaFin <> '0000-00-00' and varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and V.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  set @sql = CONCAT("select DATE_FORMAT(V.fecha_emision,'%d/%m/%Y') as FEMI, ",
                    "V.nro_pedido as PEDIDO, ",
                    "T.abrev as CTIP, CONCAT(V.nro_serie,'-', V.nro_preimpreso) as NDOC, ",                    
                    "V.id_trabajador as CVEN, CONCAT(P.apellido_paterno, ' ', P.apellido_materno, ' ', P.nombre) as VENDEDOR, ",
                    "LPAD(V.id_cliente,5,'0') as CCLI, UPPER(C.nombre) as CLIENTE, ",
                    "C.id_ruta as CRUT, UPPER(R.nombre) as RUTA, "
                    "CASE WHEN V.estado='AN' and V.id_motivo_rechazo<>0 THEN 'RECHAZADO' ",
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'PARCIAL' ",                    
                    "     WHEN V.estado='AN' and V.id_motivo_rechazo=0 THEN 'ANULADO' ",
                    "     ELSE 'COMPLETADO' ",
                    "END AS ESTADO, "
                    "LPAD(V.id_motivo_rechazo,2,'0') as CMOT, M.nombre as MOTIVO, ",
                    "sum(round(D.cantidad_ate*D.precio,2)) as TOTAL_GRAL, ",
                    "sum(CASE WHEN V.estado = 'AN' THEN round(D.cantidad_ate*D.precio,2) ",
                    "         ELSE round(D.cantidad_ate*D.precio,2) - D.total END) as RECHAZADO, ",
                    "sum(round(D.cantidad_ate*D.precio,2) - ",
                    "    CASE WHEN V.estado = 'AN' THEN round(D.cantidad_ate*D.precio,2) ",
                    "         ELSE round(D.cantidad_ate*D.precio,2) - D.total END) as EFECTIVO ",
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V ON D.id_venta = V.id_venta ",
                    "inner join _sv_tipo_doc_venta T ON V.id_tipo_doc = T.id_tipo_doc ",
                    "inner join _sv_trabajador P ON V.id_trabajador = P.id_trabajador ",                    
                    "inner join _sv_cliente C ON V.id_cliente = C.id_cliente ",
                    "inner join _sv_ruta R    ON C.id_ruta = R.id_ruta ",
                    "inner join _sv_motivo_rechazo M ON V.id_motivo_rechazo = M.id_motivo_rechazo ",
                    "where V._estado = 'A' ",
                    "and D._estado = 'A' ",
                    "and V.id_motivo_rechazo <> 0 ",
                    "and V.id_empresa = ", varEmpresa, " ",
                    varCadVendedor, varCadCliente, varCadFechaIni, varCadFechaFin,                    
                    "group by DATE_FORMAT(V.fecha_emision,'%d/%m/%Y'), ", 
                    "V.nro_pedido, ",
                    "T.abrev, CONCAT(V.nro_serie,'-',V.nro_preimpreso), ",
                    "V.id_trabajador, CONCAT(P.apellido_paterno, ' ', P.apellido_materno, ' ', P.nombre), ",                    
                    "V.id_cliente, C.nombre, ",
                    "C.id_ruta, R.nombre, ",
                    "CASE WHEN V.estado= 'AN' and V.id_motivo_rechazo<>0 THEN 'RECHAZADO' ",
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'PARCIAL' ",                    
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'ANULADO' ",
                    "     ELSE 'COMPLETADO' ",
                    "END, "
                    "V.id_motivo_rechazo, M.nombre, ",
                    "V.total ",
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;