call spQuery_Avance_Producto(1, NULL, NULL, NULL, NULL, '2012-09-01', '2012-09-15');

DROP PROCEDURE IF EXISTS spQuery_Avance_Producto;
CREATE PROCEDURE spQuery_Avance_Producto(
  varEmpresa    int,
	varTrabajador text,
  varRuta       text,
  varProveedor  int,
  varProducto   varchar(6),
	varFechaIni   date,
	varFechaFin   date
  )
BEGIN  
  DECLARE varCadVen, varCadRut, varCadPro, varCadArt, varCadIni, varCadFin TEXT DEFAULT '';
  
  if varTrabajador <> '' AND varTrabajador <> 'Todos' then
    set varCadVen = CONCAT(" and V.id_trabajador in ", varTrabajador);
  end if;
  if varRuta <> '' and varRuta is not null then
    set varCadRut = CONCAT(" and V.id_ruta in ", varRuta," ");
  end if;
  
  IF IFNULL(varProveedor,0) <> 0 and varProveedor <> '' THEN
    SET varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor, " ");  
  END IF;
  IF IFNULL(varProducto,0) <> 0 and varProducto <> '' THEN
    SET varCadPro = CONCAT(" and P.id_producto = ", varProducto, " ");  
  END IF;
  
  IF varFechaIni <> '' and varFechaIni IS NOT NULL and varFechaIni <> '0000-00-00' THEN
    SET varCadIni = CONCAT(" and V.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin <> '' and varFechaFin IS NOT NULL and varFechaFin <> '0000-00-00' THEN
    SET varCadFin = CONCAT(" and V.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  set @sql = CONCAT("SELECT V.id_trabajador as CVEN, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as VENDEDOR, ",
                    "P.id_proveedor as CPRV, L.nombre as PROVEEDOR, ",
                    "D.id_producto as CPRO, P.descripcion as PRODUCTO, ",
                    "D.id_um as UM, ",
                    "count(distinct V.id_cliente) as PDV, ",        
                    "sum(D.cantidad) as CANT, ",
                    "sum(D.subtotal) as SUBTOTAL, ",
                    "sum(D.igv) as IGV, ",
                    "sum(D.total) as TOTAL ",
                    "FROM _sv_venta_detalle D ",
                    "inner join _sv_venta V       ON D.id_venta = V.id_venta ",
                    "inner join _sv_trabajador T  ON V.id_trabajador = T.id_trabajador ",
                    "inner join _sv_producto P    ON D.id_producto = P.id_producto ",
                    "inner join _sv_proveedor L   ON P.id_proveedor = L.id_proveedor ",
                    "where V._estado = 'A' and V.estado <> 'AN' ",
                    "and V.id_empresa = ", varEmpresa, " ",
                    varCadVen, varCadRut, varCadPro, varCadArt, varCadIni, varCadFin,
                    "group by V.id_trabajador, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre), ",
                    "P.id_proveedor, L.nombre, D.id_producto, P.descripcion, D.id_um ",
                    "ORDER BY V.id_trabajador, P.id_proveedor, D.id_producto;");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;  
END;