call spMante_Venta_Update(46);

DROP PROCEDURE IF EXISTS spMante_Venta_Update;
CREATE PROCEDURE spMante_Venta_Update(
  varVenta      bigint
  )
BEGIN  
  declare varSubTotal, varIgv, varTotal double;
  
  -- CONSULTAMOS MONTOS TOTALES QUE QUEDAN
  select sum(subtotal) as subtotal, sum(igv) as igv, sum(total) as total
  into varSubTotal, varIgv, varTotal
  from _sv_venta_detalle
  where id_venta = varVenta; 
  
  -- ACTUALIZAMOS MONTO TOTAL DE CABECERA DE LA VENTA
	update _sv_venta
  set subtotal   = varSubTotal,
  igv            = varIgv,
  total          = varTotal,
  saldo          = case when estado='CA' then 0 else varTotal end
  where id_venta = varVenta;
  
  -- ACTUALIZAMOS MONTOS DE MOVIMIENTO DE CUENTA CXC
  update _sv_movimiento_cuenta_cxc 
  set monto      = varTotal
  where id_venta = varVenta;
  
  -- ACTUALIZAMOS MONTOS DE PAGOS CXC
  update _sv_pago_cxc
  set monto      = varTotal
  where id_venta = varVenta;
END;