DROP PROCEDURE IF EXISTS spMante_Venta_Devolver_Total;
CREATE PROCEDURE spMante_Venta_Devolver_Total(
  varEmpresa  int,
	varVenta    bigint,
  varMotRech  int,
  varUsuario  int
  )
BEGIN 
  /*  201 = Salida por Ventas
      208 = Salida por Bonificacion
      102 = Ingreso por Devolucion de Mercaderia
      109 = Ingreso por Devolucion de Bonificacion
  */

  Declare varExiste, varAlmacen int;
  Declare varCantidad   double;
  Declare varProducto, varMovDev   varchar(6);
  
  DECLARE done INT DEFAULT 0;
  DECLARE curDetDoc CURSOR FOR 
		      select id_producto, cantidad,
          (select id_almacen from _sv_movimiento_almacen M
                  where M.id_producto = D.id_producto
                  and M.id_referencia = D.id_venta
                  and M.id_movimiento = case when D.id_tipo = 'B' then '208' else '201' end) as id_almacen,
          case when D.id_tipo = 'B' then '109' else '102' end as MovDev
          from _sv_venta_detalle D
          where D.id_venta = varVenta;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  select count(id_venta) into varExiste from _sv_venta where id_venta= varVenta and estado <> 'AN';
  
  if varExiste > 0 then
    /*Cambiamos a Estado ANULADO=AN el Documento Seleccionado*/
    update _sv_venta 
    set estado        = 'AN', 
    subtotal          = 0, 
    igv               = 0, 
    total             = 0, 
    saldo             = 0,
    id_motivo_rechazo = varMotRech,
    _date_update      = NOW(), 
    _user_update      = varUsuario 
    where id_venta    = varVenta
    and id_empresa    = varEmpresa;    
    
    /*Anulamos los Movimientos de la Cuenta Corriente del Cliente */
    update _sv_movimiento_cuenta_cxc
    set _estado    = 'X', 
    _date_update   = NOW(), 
    _user_update   = varUsuario 
    where id_venta = varVenta
    and id_empresa = varEmpresa;
    
    /*ELIMINAMOS LOS PAGOS DE LA TABLA PAGO*/
    update _sv_pago_cxc
    set _estado    = 'X',
    _date_update   = NOW(), 
    _user_update   = varUsuario
    where id_venta = varVenta
    and id_empresa = varEmpresa;
    
    -- ELIMINAMOS LOS PRODUCTOS DEL DETALLE
    update _sv_venta_detalle
    set cantidad   = 0,
    subtotal       = 0,
    igv            = 0,
    total          = 0,
    _date_update   = NOW(),
    _user_update   = varUsuario
    where id_venta = varVenta;
    
    OPEN curDetDoc;
    REPEAT
      FETCH curDetDoc INTO varProducto, varCantidad, varAlmacen, varMovDev;
      IF NOT done THEN
        update _sv_kardex 
        SET cantidad  = cantidad + varCantidad,
        _date_update  = NOW(),
        _user_update  = varUsuario
        where id_almacen = varAlmacen
        and id_empresa   = varEmpresa 
        and id_producto  = varProducto;        
        -- Insertamos el movimiento de Devolucion
        insert into _sv_movimiento_almacen(id_movimiento, id_empresa, id_almacen, id_referencia, id_producto, cantidad, fecha,
                                          _date_create, _date_update, _user_create, _user_update)
        values(varMovDev, varEmpresa, varAlmacen, varVenta, varProducto, varCantidad, NOW(), NOW(), NOW(), varUsuario, varUsuario);
      END IF;
      
      UNTIL done END REPEAT;
    CLOSE curDetDoc;
    
  end if;
END;