call spMante_Vehiculo('NEW', NULL, 'camion fuso', 0, 'tarjpro', 'sw8085', '1985', NULL, NULL, NULL, NULL, 1);
 
DROP PROCEDURE IF EXISTS spMante_Vehiculo;
CREATE PROCEDURE spMante_Vehiculo(
	varOpcion     varchar(10),
	varCodigo     int,
	varNombre     varchar(80),
	varMarca      int,
	varTarjeta    varchar(20),
  varPlaca      varchar(20),
  varAnio       varchar(4),
  varLargo      double,
  varAncho      double,
  varAlto       double,
  varPeso       double,
  varCosto      double,
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then    
    select count(*) INTO varExiste from _sv_vehiculo 
    where _estado = 'A' 
    and (TRIM(UPPER(descripcion)) = TRIM(UPPER(varNombre)) or TRIM(UPPER(placa)) = TRIM(UPPER(varPlaca)));
    
    if varExiste <= 0 then 
      
      SELECT ifnull(max(id_vehiculo),0)+1 INTO varCodigo FROM _sv_vehiculo;    
      
      INSERT INTO _sv_vehiculo (id_vehiculo, id_marca, descripcion, placa, anio, tarjeta_propiedad, 
                                peso_max, largo, ancho, alto, monto, estado,
                                _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varMarca, UPPER(varNombre), UPPER(varPlaca), varAnio, UPPER(varTarjeta),
              varPeso, varLargo, varAncho, varAlto, varCosto, varEstado, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL VEHICULO ', varNombre, ' \nO LA PLACA ', varPlaca, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;    	
	else
    
    select count(*) INTO varExiste  from _sv_vehiculo
    where _estado = 'A'  and id_vehiculo <> varCodigo
    and (TRIM(UPPER(descripcion)) = TRIM(UPPER(varNombre)) or TRIM(UPPER(placa)) = TRIM(UPPER(varPlaca)));
    
    if varExiste <= 0 then 
      update _sv_vehiculo set      
      descripcion      = UPPER(varNombre),
      id_marca          = varMarca, 
      placa             = UPPER(varPlaca), 
      anio              = varAnio, 
      tarjeta_propiedad = UPPER(varTarjeta),
      peso_max          = varPeso, 
      largo             = varLargo, 
      ancho             = varAncho, 
      alto              = varAlto,
      monto             = varCosto,
      estado            = varEstado,
      _date_update      = NOW(),
      _user_update      = varUsuario
      where id_vehiculo = varCodigo;
    else
      set varError = CONCAT('EL VEHICULO ', varNombre, ' \nO LA PLACA ', varPlaca, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  SELECT varError;
END;