DROP PROCEDURE IF EXISTS spMante_Unidad_Medida_Indicador;
CREATE PROCEDURE spMante_Unidad_Medida_Indicador(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
  varEstado   char(1),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _sind_tabla 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('LA LA TABLA DE CONDICIONES <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_tabla),0)+1 INTO varCodigo FROM _sind_tabla;
      INSERT INTO _sind_tabla (id_tabla, nombre, estado, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varEstado, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _sind_tabla 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_tabla <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('LA LA TABLA DE CONDICIONES <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _sind_tabla set
      nombre       = UPPER(varNombre),
      estado       = varEstado,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tabla = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;