call spMante_Unidad_Medida('NEW', 'PAQ10', 'PAQUETE DE 10', 1);

DROP PROCEDURE IF EXISTS spMante_Unidad_Medida;
CREATE PROCEDURE spMante_Unidad_Medida(
	varOpcion   varchar(10),
	varCodigo   varchar(10),
	varNombre   varchar(80),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    -- Comprobamos que el nombre no exista
    select count(*) INTO varExiste
    from _sv_unid_medida
    where _estado = 'A'
    and TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre));
    if varExiste > 0 then 
      set varError = CONCAT('LA UNIDAD DE MEDIDA ', varNombre, ' YA SE ENCUENTRA REGISTRADA\n');
    end if;
    set varExiste=0;
    -- Comprobamos que el codigo no exista
    select count(*) INTO varExiste
    from _sv_unid_medida
    where _estado = 'A'
    and TRIM(UPPER(id_um)) = TRIM(UPPER(varCodigo));
    
    if varExiste > 0 then 
      if varError='OK' then
        set varError = CONCAT('EL CODIGO DE LA UNIDAD DE MEDIDA <<', varCodigo, '>> YA SE ENCUENTRA REGISTRADO\n');
      else
        set varError = CONCAT(varError, 'EL CODIGO DE LA UNIDAD DE MEDIDA <<', varCodigo, '>> YA SE ENCUENTRA REGISTRADO\n');
      end if;
    end if;
    
    if varError = 'OK' then 
      INSERT INTO _sv_unid_medida (id_um, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (UPPER(varCodigo), UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      INSERT INTO _sv_factor_conv(id_um_origen, id_um_destino, operacion, factor, _date_create, _date_update, _user_create, _user_update)
      values (UPPER(varCodigo), UPPER(varCodigo), '*', 1, NOW(), NOW(), varUsuario, varUsuario);
    end if;
	else
    select count(*) INTO varExiste
    from _sv_unid_medida
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_um <> varCodigo;
    if varExiste <= 0 then 
      update _sv_unid_medida 
      set
      nombre       = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_um = varCodigo;
    else
      set varError = CONCAT('LA UNIDAD DE MEDIDA <<', varNombre, '>> YA SE ENCUENTRA REGISTRADA');
    end if;
	end if;
  select varError;
END;