call spMante_Trabajador('EDIT', 41768484, 2, 3, 'SERRANO', 'CARRANZA', 'KENETT RONALD', '41768484', 'MZ.E LOTE 42', 
										2000, NULL, NULL, NULL, NULL, '979026496', '#0063327', NULL, NULL, NULL, NULL, 
										'A', 1);
DROP PROCEDURE IF EXISTS spMante_Trabajador;
CREATE PROCEDURE spMante_Trabajador(
	varOpcion     varchar(10),
	varCodigo     int,
  varArea       int,
  varCargo      int,
  varApePat     varchar(60),
  varApeMat     varchar(60),
	varNombre     varchar(60),
	varDni        varchar(8),
	varDirecc     varchar(80),
  varSueMes     double,
  varSueDia     double,
  varComVta     double,
  varTelef1     varchar(20),
  varTelef2     varchar(20),
  varCelular    varchar(20),
  varRpm        varchar(20),
  varRpc        varchar(20),
  varNextel     varchar(20),
  varBrevete    varchar(20),
  varEmail      varchar(80),
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Buscamos si el nombre del trabajador ya se encuentra registrado
    select count(*) INTO varExiste 
    from _sv_trabajador 
    where UPPER(CONCAT(TRIM(apellido_paterno), TRIM(apellido_materno), TRIM(nombre))) = 
          UPPER(CONCAT(TRIM(varApePat), TRIM(varApeMat), TRIM(varNombre)))
    and _estado = 'A';
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL TRABAJADOR ', upper(varApePat), ' ', upper(varApemat), ', ', upper(varNombre), ' YA SE ENCUENTRA REGISTRADO');
      set varExiste= 0;
    end if;
    
    -- Buscamos si el DNI del trabajador ya se encuentra registrado
    select count(*) INTO varExiste 
    from _sv_trabajador 
    where TRIM(nro_documento) = TRIM(varDni)
    and id_tipo_doc_identidad='01'
    and _estado = 'A';
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL Nro. DNI ', trim(varDni), ' YA SE ENCUENTRA REGISTRADO');
    end if;
    
    -- Si no se genero error insertamos el trabajador
    if varError = '' then
      set varError = 'OK';
      SELECT ifnull(max(id_trabajador),0)+1 INTO varCodigo FROM _sv_trabajador;    
      
      INSERT INTO _sv_trabajador (id_trabajador, id_area, id_cargo, 
              apellido_paterno, apellido_materno, nombre, id_tipo_doc_identidad, nro_documento, direccion, 
              sueldo_base_mensual, sueldo_base_diario, porc_comision_venta,
              telefono1, telefono2, celular, rpm, rpc, nextel, brevete, email, estado,
              _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varArea, varCargo, upper(varApePat), upper(varApeMat), upper(varNombre), 
              '01', varDni, UPPER(varDirecc), varSueMes, varSueDia, varComVta, varTelef1, varTelef2, 
              varCelular, varRpm, varRpc, varNextel, varBrevete, varEmail, varEstado,
              NOW(),NOW(), varUsuario, varUsuario);
    end if;
	else
    -- Buscamos si el nombre del trabajador ya se encuentra registrado
    select count(*) INTO varExiste 
    from _sv_trabajador 
    where UPPER(CONCAT(TRIM(apellido_paterno), TRIM(apellido_materno), TRIM(nombre))) = 
          UPPER(CONCAT(TRIM(varApePat), TRIM(varApeMat), TRIM(varNombre)))
    and _estado = 'A' and id_trabajador <> varCodigo;
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL TRABAJADOR ', upper(varApePat), ' ', upper(varApemat), ', ', upper(varNombre), ' YA SE ENCUENTRA REGISTRADO');
      set varExiste= 0;
    end if;
    
    -- Buscamos si el DNI del trabajador ya se encuentra registrado
    select count(*) INTO varExiste 
    from _sv_trabajador 
    where TRIM(nro_documento) = TRIM(varDni)
    and id_tipo_doc_identidad = '01'
    and _estado = 'A' and id_trabajador <> varCodigo;
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL Nro. DNI ', trim(varDni), ' YA SE ENCUENTRA REGISTRADO');
    end if;
    
    -- Si no se genero error actualizamos el trabajador
    if varError = '' then
      set varError = 'OK';
      -- Buscamos si el nombre del Vendedor ya se encuentra registrado
      update _sv_trabajador 
      set
      id_area             = varArea, 
      id_cargo            = varCargo, 
      apellido_paterno    = upper(varApePat), 
      apellido_materno    = upper(varApeMat), 
      nombre              = upper(varNombre), 
      nro_documento       = varDni, 
      direccion           = upper(varDirecc), 
      sueldo_base_mensual = varSueMes, 
      sueldo_base_diario  = varSueDia, 
      porc_comision_venta = varComVta,
      telefono1           = varTelef1, 
      telefono2           = varTelef2, 
      celular             = varCelular, 
      rpm                 = varRpm, 
      rpc                 = varRpc, 
      nextel              = varNextel, 
      brevete             = varBrevete, 
      email               = varEmail, 
      estado              = varEstado,
      _date_update        = NOW(),
      _user_update        = varUsuario
      where id_trabajador = varCodigo;
    end if;		
	end if;
  SELECT varError;
END;