DROP PROCEDURE IF EXISTS spMante_Tipo_Segmento;
CREATE PROCEDURE spMante_Tipo_Segmento(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sh_segmento
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_segmento),0)+1 INTO varCodigo FROM _sh_segmento;
      INSERT INTO _sh_segmento (id_segmento, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE SEGMENTO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sh_segmento
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_segmento <> varCodigo;
    if varExiste <= 0 then 
      update _sh_segmento set
      nombre       = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_segmento = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE SEGMENTO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;