DROP PROCEDURE IF EXISTS spMante_Tipo_Doc_Pago;
CREATE PROCEDURE spMante_Tipo_Doc_Pago(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
  varAbrev    varchar(20),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_forma_pago
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_forma_pago),0)+1 INTO varCodigo FROM _sv_forma_pago;
      INSERT INTO _sv_forma_pago (id_forma_pago, nombre, abrev,
                                      _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varAbrev,
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE DOCUMENTO DE PAGO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_forma_pago
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_forma_pago <> varCodigo;
    if varExiste <= 0 then 
      update _sv_forma_pago 
      set
      nombre       = UPPER(varNombre), 
      abrev        = varAbrev,       
      _date_update = NOW(),
      _user_update = varUsuario
      where id_forma_pago = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE DOCUMENTO DE PAGO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;