call spMante_Tipo_Descuento('NEW', NULL, 'O', 'FLETE DE VEHICULO', 'FLETE', 1);
 
DROP PROCEDURE IF EXISTS spMante_Tipo_Descuento;
CREATE PROCEDURE spMante_Tipo_Descuento(
	varOpcion     varchar(10),
	varCodigo     int,
  varNombre     varchar(80),
	varAbrev      varchar(20),
  varTipo       char(1),
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then    
    select count(*) INTO varExiste from _sv_tipo_descuento 
    where _estado = 'A' 
    and TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre));
    
    if varExiste <= 0 then 
      SELECT ifnull(max(id_tipo_descuento),0)+1 INTO varCodigo FROM _sv_tipo_descuento;    
      
      INSERT INTO _sv_tipo_descuento (id_tipo_descuento, nombre, abrev, tipo, estado, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo,UPPER(varNombre), varAbrev, varTipo, varEstado, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE DESCUENTO ', varNombre, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;    	
	else
    
    select count(*) INTO varExiste  from _sv_tipo_descuento
    where _estado = 'A'  and id_tipo_descuento <> varCodigo
    and TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre));
    
    if varExiste <= 0 then 
      update _sv_tipo_descuento set      
      nombre       = UPPER(varNombre),       
      abrev        = varAbrev, 
      tipo         = varTipo,
      estado       = varEstado,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tipo_descuento = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE DESCUENTO ', varNombre, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  SELECT varError;
END;