DROP PROCEDURE IF EXISTS spMante_Tipo_Cliente;
CREATE PROCEDURE spMante_Tipo_Cliente(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_tipo_cliente
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_tipo_cliente),0)+1 INTO varCodigo FROM _sv_tipo_cliente;
      INSERT INTO _sv_tipo_cliente (id_tipo_cliente, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE CLIENTE ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_tipo_cliente
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_tipo_cliente <> varCodigo;
    if varExiste <= 0 then 
      update _sv_tipo_cliente set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tipo_cliente = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE CLIENTE ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;