DROP PROCEDURE IF EXISTS spMante_Tipo_Cambio;
CREATE PROCEDURE spMante_Tipo_Cambio(
	varOpcion   varchar(10),
	varFecha    date,
	varCompra   double,
  varVenta    double,
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_tipo_cambio
    where id_fecha  = varFecha
    and _estado = 'A';
    if varExiste <= 0 then       
      INSERT INTO _sv_tipo_cambio (id_fecha, compra, venta, _date_create, _date_update, _user_create, _user_update) 
      values (varFecha, varCompra, varVenta, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE CAMBIO PARA EL DIA ', date_format(varFecha,'%d/%m/%Y'), ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    update _sv_tipo_cambio set
    compra  = varCompra,
    venta   = varVEnta,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_fecha = varFecha; 
	end if;
  select varError;
END;