Call spMante_Tarifario('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);
call spMante_Tarifario('EDIT', 1, 1, 1, 25, 20, 18, 15, 12, 10, 1);

DROP PROCEDURE IF EXISTS spMante_Tarifario;
CREATE PROCEDURE spMante_Tarifario(
	varOpcion   varchar(10),
	varEmpresa  int,
  varSegmento int,
  varHabita   int,
  varPre24    double,
  varPre12    double,
  varPre06    double,
  varPre03    double,
  varPre02    double,
  varPre01    double,
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Validamos que el nombre del almacen no exista
    select count(*) INTO varExiste  
    from _sh_tarifario 
    where id_empresa = varEmpresa
    and id_segmento  = varSegmento
    and id_habitacion= varHabita;
    if varExiste > 0 then
      set varError = CONCAT('YA SE ASIGNO EL TARIFARIO PARA ESTA HABITACION');
    end if;
    
    if varError = '' then 
      INSERT INTO _sh_tarifario (id_empresa, id_segmento, id_habitacion, 
                                 precio_24, precio_12, precio_06, precio_03, precio_02, precio_01,
                                 _date_create, _date_update, _user_create, _user_update) 
      values (varEmpresa, varSegmento, varHabita, varPre24, varPre12, varPre06, varPre03, varPre02, varPre01, 
              NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    update _sh_tarifario set
    precio_24 = varPre24, 
    precio_12 = varPre12, 
    precio_06 = varPre06, 
    precio_03 = varPre03, 
    precio_02 = varPre02, 
    precio_01 = varPre01,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_empresa = varEmpresa
    and id_segmento  = varSegmento
    and id_habitacion= varHabita;
    set varError = 'OK';
	end if;
  select varError;
END;