Call spMante_Sistema('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Sistema;
CREATE PROCEDURE spMante_Sistema(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varAbrev    varchar(20),
  varDirect   varchar(50),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    select count(*) INTO varExiste  from _sys_sistema where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    if varExiste > 0 then
      set varError = CONCAT('EL SISTEMA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_sistema),0)+1 INTO varCodigo FROM _sys_sistema;
      INSERT INTO _sys_sistema (id_sistema, nombre, abrev, directorio, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), UPPER(varAbrev), varDirect, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  from _sys_sistema where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' and id_sistema <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL SISTEMA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO\n');
    end if;
    
    if varError = '' then 
      update _sys_sistema set
      nombre      = UPPER(varNombre),
      abrev       = UPPER(varAbrev),
      directorio  = varDirect,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_sistema = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;