call spMante_Procesar_Planilla(23,'Q',NULL,NULL);

DROP PROCEDURE IF EXISTS spMante_Procesar_Planilla;
CREATE PROCEDURE spMante_Procesar_Planilla(
	varPlanilla int,
  varOpcion   varchar(1), -- Q=Query, I=Insert
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN
  DECLARE varRMV double;
  DECLARE varTipPla, varPerAfp, varPerPag int;
  DECLARE varFecIni, varFecFin date;
  -- Obtenemos Remuneracion Minima Vital
  select monto into varRMV
  from _srh_rmv  where _estado='A' order by vigencia desc limit 0,1;
  -- Obtenemos Tipo de Planilla
  select id_tipo_planilla, id_periodo_afp, id_periodo_pago, fecha_inicio, fecha_fin 
  into varTipPla, varPerAfp, varPerPag, varFecIni, varFecFin
  from _srh_planilla
  where id_planilla = varPlanilla;
  
  INSERT INTO _srh_planilla_procesada
  /*
  SELECT CPLA, CTRA, TRABAJADOR, 
  CEMP, EMPRESA, CAGE, AGENCIA, 
  CBAN, BANCO, CREG, REGIMEN, 
  CARE, AREA, CCAR, CARGO, CTIP,
  FING, FSAL, DIAS, CUENTA, CUSPP, SEGURO,
  SUELDO_BASE, SUELDO_INDI, BASICO, ASIGFAM, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(COMISION/5,0)*5+5 - COMISION) > ABS(TRUNCATE(COMISION/5,0)*5 - COMISION)
                 THEN TRUNCATE(COMISION/5,0)*5
                 ELSE TRUNCATE(COMISION/5,0)*5 + 5
            END 
       ELSE COMISION
  END AS COMISION, 
  BONO, VIATICO, VACACIONES, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(COMPUTABLE/5,0)*5+5 - COMPUTABLE) > ABS(TRUNCATE(COMPUTABLE/5,0)*5 - COMPUTABLE)
                 THEN TRUNCATE(COMPUTABLE/5,0)*5
                 ELSE TRUNCATE(COMPUTABLE/5,0)*5 + 5
            END 
       ELSE COMPUTABLE
  END AS COMPUTABLE, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(INGRESOS/5,0)*5+5 - INGRESOS) > ABS(TRUNCATE(INGRESOS/5,0)*5 - INGRESOS)
                 THEN TRUNCATE(INGRESOS/5,0)*5
                 ELSE TRUNCATE(INGRESOS/5,0)*5 + 5
            END 
       ELSE INGRESOS
  END AS INGRESOS,
  AFP_COMISION, AFP_PRIMA, AFP_FONDO, ONP, ESSALUD, DESCUENTOS, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(INGRESOS/5,0)*5+5 - INGRESOS) > ABS(TRUNCATE(INGRESOS/5,0)*5 - INGRESOS)
                 THEN TRUNCATE(INGRESOS/5,0)*5
                 ELSE TRUNCATE(INGRESOS/5,0)*5 + 5
            END - DESCUENTOS
       ELSE PAGAR
  END AS PAGAR
  */
  SELECT CPLA, CTRA, CEMP, CAGE, CBAN, CREG, CARE, CCAR, CTIP, DIAS, FING, FSAL, CUENTA, CUSPP, SEGURO,
  SUELDO_BASE, SUELDO_INDI, BASICO, ASIGFAM, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(COMISION/5,0)*5+5 - COMISION) > ABS(TRUNCATE(COMISION/5,0)*5 - COMISION)
                 THEN TRUNCATE(COMISION/5,0)*5
                 ELSE TRUNCATE(COMISION/5,0)*5 + 5
            END 
       ELSE COMISION
  END AS COMISION, 
  BONO, VIATICO, VACACIONES, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(COMPUTABLE/5,0)*5+5 - COMPUTABLE) > ABS(TRUNCATE(COMPUTABLE/5,0)*5 - COMPUTABLE)
                 THEN TRUNCATE(COMPUTABLE/5,0)*5
                 ELSE TRUNCATE(COMPUTABLE/5,0)*5 + 5
            END 
       ELSE COMPUTABLE
  END AS COMPUTABLE, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(INGRESOS/5,0)*5+5 - INGRESOS) > ABS(TRUNCATE(INGRESOS/5,0)*5 - INGRESOS)
                 THEN TRUNCATE(INGRESOS/5,0)*5
                 ELSE TRUNCATE(INGRESOS/5,0)*5 + 5
            END 
       ELSE INGRESOS
  END AS INGRESOS,
  AFP_COMISION, AFP_PRIMA, AFP_FONDO, ONP, ESSALUD, DESCUENTOS, 
  CASE WHEN varTipPla = 2
       THEN CASE WHEN ABS(TRUNCATE(INGRESOS/5,0)*5+5 - INGRESOS) > ABS(TRUNCATE(INGRESOS/5,0)*5 - INGRESOS)
                 THEN TRUNCATE(INGRESOS/5,0)*5
                 ELSE TRUNCATE(INGRESOS/5,0)*5 + 5
            END - DESCUENTOS
       ELSE PAGAR
  END AS PAGAR,
  NOW(), NOW(), 1, 1, 'A'
  FROM
    (
    select varPlanilla AS CPLA, CTRA, TRABAJADOR, 
    CEMP, EMPRESA, CAGE, AGENCIA, 
    CBAN, BANCO, CREG, REGIMEN, 
    CARE, AREA, CCAR, CARGO, CTIP,
    FING, FSAL, DIAS, CUENTA, CUSPP, SEGURO, SUELDO_BASE, SUELDO_INDI,
    ROUND(IFNULL(BASICO,0)/30*DIAS,2) AS BASICO,
    ASIGFAM,
    ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                         THEN IFNULL(SUELDO_INDI,0)/30*DIAS 
                         ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                    END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
               THEN 0
               ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                         THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                         ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                    END 
                    - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
                    -- + IFNULL(INGRE_COMPU,0) 
          END,2) AS COMISION,
    
    CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                   THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                   ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
              END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
        THEN IFNULL(BONO,0) - ABS(CASE WHEN SUELDO_INDI IS NOT NULL 
                                       THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                       ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                  END 
                                - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0))
        ELSE BONO
    END AS BONO, 
    VIATICO,
    NULL AS VACACIONES,
    -- COMPUTABLE
    ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
    IFNULL(ASIGFAM,0) +
    ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                         THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                         ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                    END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
              THEN 0
              ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                        THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                        ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                    END 
                    - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
          END,2) +
    IFNULL(INGRE_COMPU,0) AS COMPUTABLE,
    -- TOTAL INGRESOS
    ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
    IFNULL(ASIGFAM,0) +
    ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                        THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                        ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                    END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
              THEN 0
              ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                        THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                        ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                    END 
                    - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
          END,2) +
    CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                  THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                  ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
              END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
        THEN IFNULL(BONO,0) - ABS(CASE WHEN SUELDO_INDI IS NOT NULL 
                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                END 
                                - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0))
        ELSE BONO
    END +
    IFNULL(INGRE_COMPU,0) +
    IFNULL(INGRE_OTRO,0) +
    IFNULL(VIATICO,0) AS INGRESOS,
    
    -- CALCULO DE REGIMENES
    CASE WHEN TIPOREG = 'P' 
        THEN ROUND(AFPCOM/100*( ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
                                IFNULL(ASIGFAM,0) +
                                ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
                                          THEN 0
                                          ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END 
                                                - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
                                      END,2) +
                                IFNULL(INGRE_COMPU,0)),2)
    END AS AFP_COMISION,
    
    CASE WHEN TIPOREG = 'P' 
        THEN ROUND(AFPPRI/100*( ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
                                IFNULL(ASIGFAM,0) +
                                ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
                                          THEN 0
                                          ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END 
                                                - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
                                      END,2) +
                                IFNULL(INGRE_COMPU,0)),2)
    END AS AFP_PRIMA,
    
    CASE WHEN TIPOREG = 'P' 
        THEN ROUND(AFPFON/100*( ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
                                IFNULL(ASIGFAM,0) +
                                ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS 
                                                END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
                                          THEN 0
                                          ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END 
                                                - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
                                      END,2) +
                                IFNULL(INGRE_COMPU,0)),2)
    END AS AFP_FONDO,
    
    CASE WHEN TIPOREG = 'N' 
        THEN ROUND(AFPFON/100*( ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
                                IFNULL(ASIGFAM,0) +
                                ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
                                          THEN 0
                                          ELSE CASE WHEN SUELDO_INDI IS NOT NULL 
                                                    THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                                    ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                                END 
                                                - IFNULL(BONO,0) - ROUND(IFNULL(BASICO,0)/30*DIAS,2) - IFNULL(ASIGFAM,0)
                                      END,2) +
                                IFNULL(INGRE_COMPU,0)),2)
    END AS ONP,
    -- ESSALUD
    CASE WHEN varTipPla = 1 
         THEN ROUND(0.09*(ROUND(IFNULL(BASICO,0)/30*DIAS,2) +
                          IFNULL(ASIGFAM,0) +
                          ROUND(CASE WHEN CASE WHEN SUELDO_INDI IS NOT NULL 
                                              THEN IFNULL(SUELDO_INDI,0)/30*DIAS
                                              ELSE IFNULL(SUELDO_BASE,0)/30*DIAS
                                          END  < IFNULL(BONO,0) + ROUND(IFNULL(BASICO,0)/30*DIAS,2) + IFNULL(ASIGFAM,0)
                                    THEN 0
                    