Call spMante_Planilla_Periodicidad('NEW', NULL, 'VACACIONES', 1);

DROP PROCEDURE IF EXISTS spMante_Planilla_Periodicidad;
CREATE PROCEDURE spMante_Planilla_Periodicidad(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_tipo_periodicidad 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL TIPO DE PERIODICIDAD DE PLANILLA <<', UPPER(varNombre), '>> YA SE ENCUENTRO REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_tipo_periodicidad),0)+1 INTO varCodigo FROM _srh_tipo_periodicidad;
      INSERT INTO _srh_tipo_periodicidad (id_tipo_periodicidad, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_tipo_periodicidad 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_tipo_periodicidad <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL TIPO DE PERIODICIDAD DE PLANILLA <<', UPPER(varNombre), '>> YA SE ENCUENTRO REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_tipo_periodicidad set
      nombre       = UPPER(varNombre),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tipo_periodicidad = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;