Call spMante_Planilla('NEW', NULL, 'VACACIONES', 1);

DROP PROCEDURE IF EXISTS spMante_Planilla;
CREATE PROCEDURE spMante_Planilla(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varTipoPla  varchar(2),
  varPeriodi  varchar(2),
  varPerPago  int,
  varPerAfp   int,
  varInicio   date,
  varCierre   date,
  varDias     int,
  varEstado   char(1),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_planilla 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) 
    and id_tipo_planilla      = varTipoPla
    and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('LA PLANILLA <<', UPPER(varNombre), '>> YA SE ENCUENTRO REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_planilla),0)+1 INTO varCodigo FROM _srh_planilla;
      INSERT INTO _srh_planilla (id_planilla, id_tipo_planilla, id_tipo_periodicidad, id_periodo_pago, id_periodo_afp,
                                 nombre, fecha_inicio, fecha_fin, dias_trabajados, estado,
                                 _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varTipoPla, varPeriodi, varPerPago, varPerAfp, 
              UPPER(varNombre), varInicio, varCierre, varDias, varEstado, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_planilla 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) 
    and id_tipo_planilla      = varTipoPla
    and _estado = 'A' 
    and id_planilla <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('LA PLANILLA <<', UPPER(varNombre), '>> YA SE ENCUENTRO REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_planilla set
      id_tipo_planilla      = varTipoPla, 
      id_tipo_periodicidad  = varPeriodi, 
      id_periodo_pago       = varPerPago, 
      id_periodo_afp        = varPerAfp,
      nombre                = UPPER(varNombre), 
      fecha_inicio          = varInicio, 
      fecha_fin             = varCierre, 
      dias_trabajados       = varDias, 
      estado                = varEstado,
      _date_update          = NOW(),
      _user_update          = varUsuario
      where id_planilla     = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;