CALL spMante_Pago_CxP(3, 1, '0001', '2012-06-3', 51, 'Pago en Efectivo', 1);

DROP PROCEDURE IF EXISTS spMante_Pago_CxP;
CREATE PROCEDURE spMante_Pago_CxP(
	varCompra     int,
  varFormaPago  int,
	varDocumento  varchar(20),
  varFecha      date,
  varMonto      double,	
  varObserva    text,
  varUsuario    int
  )
BEGIN
  DECLARE varNumPago bigint;
  DECLARE varEmp, varPro int;
  DECLARE varSal double default 0;
  DECLARE varError text default 'OK';
  
  select id_empresa, id_proveedor, ifnull(saldo,0)
  into varEmp, varPro, varSal
  from _sv_compra
  where id_compra = varCompra;
  
  SELECT if(isnull(MAX(id_pago_cxp)),0,MAX(id_pago_cxp))+1 INTO varNumPago FROM _sv_pago_cxp; 
  
  IF varMonto = varSal THEN
    UPDATE _sv_compra SET estado = 'CA', saldo = saldo - varMonto, _user_update = varUsuario, _date_update=NOW() 
    where id_compra = varCompra;
  ELSEIF varMonto < varSal THEN
    UPDATE _sv_compra SET estado = 'PP', saldo = saldo - varMonto, _user_update = varUsuario, _date_update=NOW() 
    where id_compra = varCompra;
  ELSE
    set varError = "EL MONTO A PAGAR ES MAYOR AL SALDO";
  END IF;
  
  if varError = "OK" then
    /*REGISTRAMOS EL VOUCHER DE PAGO*/
    insert into _sv_pago_cxp(id_pago_cxp, id_empresa, id_proveedor, id_compra, id_forma_pago, nro_doc_pago, fecha, monto, observacion, _date_create, _date_update, _user_create, _user_update)
    values(varNumPago, varEmp, varPro, varCompra, varFormaPago, varDocumento, varFecha, varMonto, varObserva, NOW(), NOW(), varUsuario, varUsuario);
    
    /*REGISTRAMOS EL MOVIMIENTO DE LA CUENTA*/
    insert into _sv_movimiento_cuenta_cxp(id_empresa, id_proveedor, id_compra, id_pago_cxp, tipo_mov, fecha, monto, _date_create, _date_update, _user_create, _user_update)
    values (varEmp, varPro, varCompra, varNumPago, 'PAG', varFecha, varMonto, NOW(), NOW(), varUsuario, varUsuario);
  end if;
  select varError;
END;