CALL spMante_Pago_CxC_Modificar(280, 50, '', 1);

DROP PROCEDURE IF EXISTS spMante_Pago_CxC_Modificar;
CREATE PROCEDURE spMante_Pago_CxC_Modificar(
	varPago       int,   
  varMonto      double,	
  varObserva    text,
  varUsuario    int
  )
BEGIN  
-- DISTRIBUCIONES MENFAR
  DECLARE varVenta  int;
  DECLARE varMontoAnt, varSaldoAct, varSaldoNew  double;
  
  select id_venta, monto into varVenta, varMontoAnt
  from _sv_pago_cxc where id_pago_cxc=varPago;  
  
  -- CONSULTAMOS SALDO ACTUAL y NUEVO SALDO DEL DOCUMENTO
  select  saldo into varSaldoAct from _sv_venta where id_venta = varVenta;
  set varSaldoNew = varSaldoAct + varMontoAnt-varMonto;
  
  -- ACTUALIZAMOS EL REGISTRO DE VENTAS
  IF round(varSaldoNew,2) = 0 THEN  
    update _sv_venta set saldo=round(varSaldoNew,2), estado='CA' where id_venta=varVenta;
  ELSE
    update _sv_venta set saldo=round(varSaldoNew,2), estado='PP' where id_venta=varVenta;
  END IF;
  
  
  /*ACTUALIZAMOS EL VOUCHER DE PAGO*/
  update _sv_pago_cxc 
  set monto = varMonto,
  observacion = concat(observacion,' ',varObserva),
  _date_update = NOW(),
  _user_update = varUsuario
  where id_pago_cxc = varPago
  and _estado = 'A';
  
  /*ACTUALIZAMOS EL MOVIMIENTO DE LA CUENTA*/
  update _sv_movimiento_cuenta_cxc
  set monto = varMonto,
  _date_update = NOW(),
  _user_update = varUsuario
  where tipo_mov='PAG'
  and id_pago_cxc = varPago
  and _estado = 'A'; 
END;
