DROP PROCEDURE IF EXISTS spMante_Motivo_Rechazo;
CREATE PROCEDURE spMante_Motivo_Rechazo(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_motivo_rechazo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_motivo_rechazo),0)+1 INTO varCodigo FROM _sv_motivo_rechazo;
      INSERT INTO _sv_motivo_rechazo (id_motivo_rechazo, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL MOTIVO DE RECHAZO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_motivo_rechazo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_motivo_rechazo <> varCodigo;
    if varExiste <= 0 then 
      update _sv_motivo_rechazo set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_motivo_rechazo = varCodigo;
    else
      set varError = CONCAT('EL MOTIVO DE RECHAZO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;