call spMante_Modulo('EDIT', 017101, 'MOD. OLMOS 1 asasa',17, 1);

DROP PROCEDURE IF EXISTS spMante_Modulo;
CREATE PROCEDURE spMante_Modulo(
	varOpcion   varchar(10),
	varCodigo   varchar(10),
	varNombre   varchar(80),
  varRuta     varchar(10),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_modulo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      -- Obtenemos Codigo del Modulo
      select ifnull(max(substring(id_modulo,LENGTH(TRIM(varRuta))+1,2)),0)+1 INTO varCodigo 
      from _sv_modulo 
      where id_ruta = varRuta;
      set varCodigo = CONCAT(TRIM(varRuta),LPAD(varCodigo,2,'0'));
      
      INSERT INTO _sv_modulo (id_modulo, id_ruta, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varRuta, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL MODULO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_modulo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_modulo <> varCodigo;
    if varExiste <= 0 then 
      update _sv_modulo set
      id_ruta = varRuta,
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_modulo = varCodigo;
    else
      set varError = CONCAT('EL MODULO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;