Call spMante_Matriz_IP('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Matriz_IP;
CREATE PROCEDURE spMante_Matriz_IP(
	varOpcion   varchar(10),
	varCodigo   int,
  varArea     int,
	varNombre   varchar(100),
  varAbrev    varchar(50),
  varBase     double,
  varEstado   char(1),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _sind_matriz 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('LA MATRIZ IP <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_matriz),0)+1 INTO varCodigo FROM _sind_matriz;
      INSERT INTO _sind_matriz (id_matriz, id_area, nombre, base, estado, abrev, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varArea, UPPER(varNombre), UPPER(varAbrev), varBase, varEstado, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _sind_matriz 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_matriz <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('LA MATRIZ IP <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _sind_matriz set
      nombre       = UPPER(varNombre),
      id_area      = varArea,
      abrev        = UPPER(varAbrev),
      base         = varBase,
      estado       = varEstado,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_matriz = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;