call spMante_Instituto('EDIT', '147', 'MANUEL ANTONIO MESONES MURO', '01', '10', 1);

DROP PROCEDURE IF EXISTS spMante_Instituto;
CREATE PROCEDURE spMante_Instituto(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varDepart   varchar(2),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_instituto 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  
    and _estado = 'A'
    and id_departamento = varDepart;
    
    if varExiste > 0 then
      set varError = CONCAT('EL INSTITUTO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_instituto),0)+1 INTO varCodigo FROM _srh_instituto;
      INSERT INTO _srh_instituto (id_instituto, id_departamento, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varDepart, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_instituto 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_instituto <> varCodigo
    and id_departamento = varDepart;
    if varExiste > 0 then
      set varError = CONCAT('EL INSTITUTO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_instituto set
      nombre          = UPPER(varNombre),
      id_departamento = varDepart,
      _date_update    = NOW(),
      _user_update    = varUsuario
      where id_instituto = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;