call spMante_Hospedaje_CheckOut(1, 3, '2012-08-31 12:51:00', 1);

DROP PROCEDURE IF EXISTS spMante_Hospedaje_CheckOut;
CREATE PROCEDURE spMante_Hospedaje_CheckOut(
	varCodigo     int,
	varCliente    int,
  varSalida     datetime,
  varUsuario    int
)
BEGIN  
  DECLARE varExiste int default 0;
  DECLARE varHospedaje, varReserva, varHabitacion  int default NULL;
  DECLARE varPrecio, varDias, varHoras, varTotal, varSubTotal, varIgv double default 0;
  DECLARE varIngreso datetime;
  
  DECLARE done INT DEFAULT 0;
	DECLARE curHab CURSOR FOR 
			select id_habitacion, precio
      from _sh_hospedaje_habitacion
      where id_hospedaje = varCodigo
      and _estado = 'A';
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  
  select id_hospedaje, id_reservacion, fecha_ingreso, count(*)
  into varHospedaje, varReserva, varIngreso, varExiste
  from _sh_hospedaje 
  where id_hospedaje=varCodigo and estado='AC'
  group by id_hospedaje, id_reservacion, fecha_ingreso;
  
  set varDias  = DATEDIFF(varSalida, varIngreso);
  set varHoras = TIME_TO_SEC(TIMEDIFF(DATE_FORMAT(varSalida,'%h:%i:%s'),DATE_FORMAT(varIngreso,'%h:%i:%s')))/3600;

  if varExiste > 0 then
    OPEN curHab;
    REPEAT
      FETCH curHab INTO varHabitacion, varPrecio;
      IF NOT done THEN      
          set varTotal = round(varPrecio*varDias,2);
          set varSubTotal = round(round(varPrecio*varDias,2)/1.18,2);
          set varIgv = varTotal - varSubTotal;
          
          /* Actualizamos detalle del Hospedaje */
          update _sh_hospedaje_habitacion
          set estado    = 'FI',
          total         = varTotal,
          subtotal      = varSubTotal,
          igv           = varIgv,
          fecha_salida  = varSalida
          where id_hospedaje = varCodigo
          and id_habitacion  = varHabitacion;
          
          /* Insertamos movimiento de Habitacion */
          insert into _sh_movimiento_habitacion values(NULL, 'OUT', varHabitacion, varHospedaje, varReserva, varSalida, 
                                                       NOW(), NOW(), varUsuario, varUsuario, 'A');
          
      END IF;
      UNTIL done END REPEAT;
    CLOSE curHab;
    /* Actualizamos estado del hospedaje */
    update _sh_hospedaje H
    set estado    = 'FI',
    id_cliente    = varCliente,
    fecha_salida  = varSalida,
    subtotal      = (select sum(subtotal) from _sh_hospedaje_habitacion HH where HH._estado = 'A' and HH.id_hospedaje = H.id_hospedaje),
    igv           = (select sum(igv)      from _sh_hospedaje_habitacion HH where HH._estado = 'A' and HH.id_hospedaje = H.id_hospedaje),
    total         = (select sum(total)    from _sh_hospedaje_habitacion HH where HH._estado = 'A' and HH.id_hospedaje = H.id_hospedaje),
    saldo         = (select sum(total)    from _sh_hospedaje_habitacion HH where HH._estado = 'A' and HH.id_hospedaje = H.id_hospedaje) -
                    (select sum(monto)    from _sh_hospedaje_acuenta HA where HA._estado = 'A' and HA.id_hospedaje = H.id_hospedaje),
    _date_update  = NOW(),
    _user_update  = varUsuario
    where id_hospedaje = varCodigo
    and estado = 'AC';
  end if;
  
  select varCodigo;
END;