call spMante_Hospedaje_CheckOut_Habitacion(6, 20, '2012-09-12 19:13:00', 1.00, '09:13', 30.00, 30.00, 60.00, 1);

DROP PROCEDURE IF EXISTS spMante_Hospedaje_CheckOut_Habitacion;
CREATE PROCEDURE spMante_Hospedaje_CheckOut_Habitacion(
	varHospedaje  int,
  varHabitacion int,
  varFecha      datetime,
  varCanDias    double,
  varCanHora    double,
  varPreDias    double,
  varPreHora    double,
  varTotal      double,
  varUsuario    int
)
BEGIN  
  DECLARE varSub, varIgv  double default 0;
  DEClARE varReserva  int default 0;
  
  set varSub = round(varTotal/1.18,2);
  set varIgv = round(varTotal - varSub,2);
  
  select id_reservacion into varReserva
  from _sh_hospedaje
  where id_hospedaje = varHospedaje;
          
  /* Actualizamos detalle del Hospedaje */
  update _sh_hospedaje_habitacion
  set estado    = 'FI',
  can_dias      = varCanDias,
  can_hora      = varCanHora,
  pre_dias      = varPreDias,
  pre_hora      = varPreHora,
  total         = varTotal,
  subtotal      = varSub,
  igv           = varIgv,
  fecha_salida  = varFecha
  where id_hospedaje = varHospedaje
  and id_habitacion  = varHabitacion;
  
  /* Insertamos movimiento de Habitacion */
  insert into _sh_movimiento_habitacion(id_tipo_mov_hab, id_habitacion, id_hospedaje, id_reservacion, fecha,
                                        _date_create, _date_update, _user_create, _user_update) 
  values('OUT', varHabitacion, varHospedaje, varReserva, varFecha, NOW(), NOW(), varUsuario, varUsuario);

END;